/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.message.DataSourceMessageSource}
 * NX̃ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4>
 * DAO擾bZ[W\[XAbZ[WR[hyуP[L[<br>
 * ƂāAbZ[W̓bZ[WtH[}bg肷NX
 * <p>
 * 
 * @see jp.terasoluna.fw.message.DataSourceMessageSource
 */
public class DataSourceMessageSourceTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DataSourceMessageSourceTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public DataSourceMessageSourceTest(String name) {
        super(name);
    }

    /**
     * testSetDefaultLocale01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() defaultLocale:Locale JAPAN<br>
     *         () this.defaultLocale:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.defaultLocale:Őݒ肵Locale<br>
     *         
     * <br>
     * Localesetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDefaultLocale01() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        ds.defaultLocale = null;
        
        Locale locale = Locale.JAPAN;
        
        // eXg{
        ds.setDefaultLocale(locale);

        // 
        assertEquals(locale, ds.defaultLocale);
    }

    /**
     * testSetDbMessageResourceDAO01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() dbMessageResourceDAO:DBMessageResourceDAOIuWFNg<br>
     *         () this.dbMessageResourceDAO:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.dbMessageResourceDAO:Őݒ肵DAOIuWFNg<br>
     *         
     * <br>
     * DBMessageResourceDAOsetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDbMessageResourceDAO01() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        ds.dbMessageResourceDAO = null;

        // eXg{
        ds.setDbMessageResourceDAO(dbmr);
        // 
        assertSame(dbmr, ds.dbMessageResourceDAO);
    }

    /**
     * testAfterPropertiesSet01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF
     * <br>
     * ҒlF(ԕω) readMessageFromDataSource:ĂяoĂ̂mFB<br>
     *         
     * <br>
     * afterPropertiesSetsreadMessageFromDataSourceŝmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet01() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub01 ds
                = new DataSourceMessageSource_DataSourceMessageSourceStub01();

        // eXg{
        ds.afterPropertiesSet();

        // 
        assertTrue(ds.isRead);
    }

    /**
     * testReloadDataSourceMessage01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF
     * <br>
     * ҒlF(ԕω) readMessageFromDataSource:ĂяoĂ̂mFB<br>
     *         
     * <br>
     * reloadDataSourceMessagesreadMessageFromDataSourceŝmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testReloadDataSourceMessage01() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub01 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub01();

        // eXg{
        ds.reloadDataSourceMessage();

        // 
        assertTrue(ds.isRead);
    }

    /**
     * testReadMessageFromDataSource01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():List̗vfO<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         
     * <br>
     * DBMessagẽLbVsȂꂸAȂŏIB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource01() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);
        ds.dbMessageResourceDAO = dbmr;
        
        dbmr.list = new ArrayList();
        
        // eXg{
        ds.readMessagesFromDataSource();

        // 
        assertTrue(ds.cachedMergedProperties.isEmpty());
        assertTrue(ds.cachedMessageFormats.isEmpty());
        assertTrue(dbmr.isRead);
        assertEquals(0, ds.list.size());
    }

    /**
     * testReadMessageFromDataSource02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():List̗vfP<br>
     *                DBMessage("test01","JP","ja","kaisai","eXgbZ[WOP")<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         (ԕω) mapMessage():ĂяoꂽƂmFB<br>
     *                    킽Ă邱ƂmFB<br>
     *         
     * <br>
     * DBMessageIuWFNgloA}bvɂ߂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource02() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);
        ds.dbMessageResourceDAO = dbmr;
        
        List<DBMessage> list = new ArrayList<DBMessage>();
        DBMessage db1 = new DBMessage("test01", "JP", "ja", "kaisai",
                "eXgbZ[WOP");
        list.add(db1);
        dbmr.list = list;
        
     
        // eXg{
        ds.readMessagesFromDataSource();

        // 
        assertTrue(ds.cachedMergedProperties.isEmpty());
        assertTrue(ds.cachedMessageFormats.isEmpty());
        assertTrue(dbmr.isRead);
        assertEquals(1, ds.list.size());
        assertSame(db1, ds.list.get(0));
    }

    /**
     * testReadMessageFromDataSource03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():LIst̗vfR<br>
     *                DBMessage("test01","JP","ja","kaisai","eXgbZ[WOP")<br>
     *                DBMessage("test02","JP","ja","kaisai","eXgbZ[WOQ")<br>
     *                DBMessage("test03","JP","ja","kaisai","eXgbZ[WOR")<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         (ԕω) mapMessage():ĂяoꂽƂmFB<br>
     *                    킽Ă邱ƂmFB<br>
     *         
     * <br>
     * DBMessageIuWFNgloA}bvɂ߂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource03() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);
        
        ds.dbMessageResourceDAO = dbmr;
        
        List<DBMessage> list = new ArrayList<DBMessage>();
        DBMessage db1 = new DBMessage("test01", "JP", "ja", "kaisai",
                "eXgbZ[WOP");
        DBMessage db2 = new DBMessage("test02", "JP", "ja", "kaisai",
                "eXgbZ[WOQ");
        DBMessage db3 = new DBMessage("test03", "JP", "ja", "kaisai",
                "eXgbZ[WOR");
        list.add(db1);
        list.add(db2);
        list.add(db3);
        dbmr.list = list;        

        // eXg{
        ds.readMessagesFromDataSource();

        // 
        assertTrue(ds.cachedMergedProperties.isEmpty());
        assertTrue(ds.cachedMessageFormats.isEmpty());
        assertTrue(dbmr.isRead);
        assertEquals(3, ds.list.size());
        assertSame(db1, ds.list.get(0));
        assertSame(db2, ds.list.get(1));
        assertSame(db3, ds.list.get(2));
    }

    /**
     * testReadMessageFromDataSource04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():List̗vfP<br>
     *                DBMessage("","","","","")<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         (ԕω) mapMessage():ĂяoꂽƂmFB<br>
     *                    킽Ă邱ƂmFB<br>
     *         
     * <br>
     * DBMessageIuWFNgloA}bvɂ߂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource04() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);
        
        ds.dbMessageResourceDAO = dbmr;
        
        List<DBMessage> list = new ArrayList<DBMessage>();
        DBMessage db1 = new DBMessage("", "", "", "", "");
        
        list.add(db1);
        dbmr.list = list;           
        

        // eXg{
        ds.readMessagesFromDataSource();

        // 
        assertTrue(ds.cachedMergedProperties.isEmpty());
        assertTrue(ds.cachedMessageFormats.isEmpty());
        assertTrue(dbmr.isRead);
        assertEquals(1, ds.list.size());
        assertSame(db1, ds.list.get(0));
    }

    /**
     * testReadMessageFromDataSource05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():List̗vfP<br>
     *                DBMessage(null,null,null.null.null)<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         (ԕω) mapMessage():ĂяoĂȂƂmFB<br>
     *         
     * <br>
     * bZ[WR[h̓bZ[W{̂Ȃƃ}bvɊi[ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource05() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);
        
        ds.dbMessageResourceDAO = dbmr;
        
        List list = new ArrayList();
        DBMessage db1 = new DBMessage(null, null, null, null, null);
        list.add(db1);
        dbmr.list = list;
        
        // eXg{
        ds.readMessagesFromDataSource();

        // 
        assertTrue(ds.cachedMergedProperties.isEmpty());
        assertTrue(ds.cachedMessageFormats.isEmpty());
        assertTrue(dbmr.isRead);
        assertEquals(0, ds.list.size());
    }

    /**
     * testReadMessageFromDataSource06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():LIst̗vfP<br>
     *                DBMessage(null,"JP","ja","kaisai","eXgbZ[WOP")<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         (ԕω) mapMessage():ĂяoĂȂƂmFB<br>
     *         
     * <br>
     * bZ[WR[h̓bZ[W{̂Ȃƃ}bvɊi[ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource06() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);

        ds.dbMessageResourceDAO = dbmr;
        
        List list = new ArrayList();
        DBMessage db1 
            = new DBMessage(null, "JP", "ja", "kaisai", "eXgbZ[WOP");
        list.add(db1);
        dbmr.list = list;
        
        // eXg{
        ds.readMessagesFromDataSource();

        // 
        assertTrue(ds.cachedMergedProperties.isEmpty());
        assertTrue(ds.cachedMessageFormats.isEmpty());
        assertTrue(dbmr.isRead);
        assertEquals(0, ds.list.size());
    }

    /**
     * testReadMessageFromDataSource07() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():List̗vfP<br>
     *                DBMessage("test01","JP","ja","kaisai",null)<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         (ԕω) mapMessage():ĂяoĂȂƂmFB<br>
     *         
     * <br>
     * bZ[WR[h̓bZ[W{̂Ȃƃ}bvɊi[ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource07() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);

        ds.dbMessageResourceDAO = dbmr;
        List list = new ArrayList();
        DBMessage db1 = new DBMessage("test01", "JP", "ja", "kaisai", null);
        list.add(db1);   
        
        dbmr.list = list;        
        
        // eXg{
        ds.readMessagesFromDataSource();

        // 
        assertTrue(ds.cachedMergedProperties.isEmpty());
        assertTrue(ds.cachedMessageFormats.isEmpty());
        assertTrue(dbmr.isRead);
        assertEquals(0, ds.list.size());
    }

    /**
     * testReadMessageFromDataSource08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE,G <br>
     * <br>
     * ͒lF() dbMessageResourceDAO.findDBMessage():List̗vfP<br>
     *                DBMessageIuWFNgȊÕIuWFNg<br>
     *         
     * <br>
     * ҒlF(ԕω) cachedMergedProperties.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) cachedMessageFormats.clear():Ăяo邱ƂmFB<br>
     *         (ԕω) dbMessageResourceDAO.findDBMessage():Ăяo邱ƂmFB<br>
     *         (ԕω) mapMessage():ĂяoĂȂƂmFB<br>
     *         (ԕω) O:ClassCastException<br>
     *         
     * <br>
     * DBMessageIuWFNgnȂƁAO邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadMessageFromDataSource08() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub02 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub02();
        DataSourceMessageSource_DBMessageResoueceDAOStub01 dbmr 
                = new DataSourceMessageSource_DBMessageResoueceDAOStub01();
        Properties prop = new Properties();
        HashMap map = new HashMap();
        ds.cachedMergedProperties.put(Locale.JAPAN, prop);
        ds.cachedMessageFormats.put("foo", map);

        ds.dbMessageResourceDAO = dbmr;
        List list = new ArrayList();
        Object db1 = new Object();
        list.add(db1);
        dbmr.list = list;
        
        try {
            // eXg{
            ds.readMessagesFromDataSource();
            fail();
        } catch (ClassCastException e) {
            // 
            assertTrue(ds.cachedMergedProperties.isEmpty());
            assertTrue(ds.cachedMessageFormats.isEmpty());
            assertTrue(dbmr.isRead);
            assertEquals(0, ds.list.size());
        }
    }

    /**
     * testMapMessage01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() message:DBMessageIuWFNg<br>
     *         
     * <br>
     * ҒlF(ԕω) createLocale(message):w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         (ԕω) getMessages:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         (ԕω) messages:message擾lmessagesɊi[Ă邱ƂmFB<br>
     *         
     * <br>
     * 擾DBMessageIuWFNgloAe[uɊi[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapMessage01() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub03 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub03();
        DBMessage message = new DBMessage("a", "b", "c", "d", "e");
        Locale locale = new Locale("ja", "JP");
        ds.locale = locale;
        Properties props = new Properties();
        ds.messages = props;
        
        // eXg{
        ds.mapMessage(message);

        // 
        assertSame(message, ds.dbm);
        assertSame(locale, ds.locale2);
        assertSame(props, ds.messages);

    }

    /**
     * testCreateLocale01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() message:LanguageJnull̏ꍇB<br>
     *                DBMessage("test01",null,null,null,"eXgbZ[WOP")<br>
     *         () defaultLocale:Locale.FRENCH<br>
     *         
     * <br>
     * ҒlF(߂l) LocaleIuWFNg:Locale("fr","","")<br>
     *         
     * <br>
     * ^ꂽLocalełȂꍇAftHgP[gB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale01() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        DBMessage message = new DBMessage("test01", null, null, null,
                "eXgbZ[WOP");
        ds.defaultLocale = Locale.FRENCH;

        // eXg{
        Locale returnLocale = ds.createLocale(message);

        // 
        assertSame(ds.defaultLocale, returnLocale);
    }

    /**
     * testCreateLocale02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() message:LanguageJnull̏ꍇB<br>
     * DBMessage("test01",null,null,null,"eXgbZ[WOP")<br>
     * () defaultLocale:null<br>
     * <br>
     * ҒlF(߂l) LocaleIuWFNg:OB<br>
     * (ԕω) O:IllegalArgumentException<br>
     * bZ[WFCan't resolve Locale.Define Locale in MessageSource or
     * Defaultlocale<br>
     * (ԕω) O:G[OFCan't resolve Locale.Define Locale in MessageSource or
     * Defaultlocale<br>
     * <br>
     * LocalewłAOoB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testCreateLocale02() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        DBMessage message = new DBMessage("test01", null, null, null,
                "eXgbZ[WOP");
        ds.defaultLocale = null;

        // eXg{
        try {
            ds.createLocale(message);
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "Can't resolve Locale.Define Locale in MessageSource or Defaultlocale.",
                    e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("Can't resolve Locale.Define Locale in MessageSource or Defaultlocale."));
        }
    }

    /**
     * testCreateLocale03() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() message:CountryJnull̏ꍇB<br>
     *                DBMessage("test01","ja",null,null,"eXgbZ[WOP")<br>
     *         () defaultLocale:null<br>
     *         
     * <br>
     * ҒlF(߂l) LocaleIuWFNg:Locale("ja","","")<br>
     *         
     * <br>
     * ^ꂽALocale肷B^͌R[hłB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale03() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        DBMessage message = new DBMessage("test01", "ja", null, null,
                "eXgbZ[WOP");
        ds.defaultLocale = null;

        // eXg{
        Locale returnLocale = ds.createLocale(message);

        // 
        assertEquals("ja", returnLocale.getLanguage());
        assertEquals("", returnLocale.getCountry());
        assertEquals("", returnLocale.getVariant());
    }

    /**
     * testCreateLocale04() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() message:VariantJnull̏ꍇB<br>
     *                DBMessage("test01","ja","JP",null,"eXgbZ[WOP")<br>
     *         () defaultLocale:null<br>
     *         
     * <br>
     * ҒlF(߂l) LocaleIuWFNg:Locale("ja","JP","")<br>
     *         
     * <br>
     * ^ꂽALocale肷B^͌R[hƍR[hłB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale04() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        DBMessage message = new DBMessage("test01", "ja", "JP", null,
                "eXgbZ[WOP");
        ds.defaultLocale = null;

        // eXg{
        Locale returnLocale = ds.createLocale(message);

        // 
        assertEquals("ja", returnLocale.getLanguage());
        assertEquals("JP", returnLocale.getCountry());
        assertEquals("", returnLocale.getVariant());

    }

    /**
     * testCreateLocale05() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
      * ͒lF() message:VariantJnullłȂꍇB<br>
     *                DBMessage("test01","ja","JP","kansai","eXgbZ[WOP")<br>
     *         () defaultLocale:null<br>
     *         
     * <br>
     * ҒlF(߂l) LocaleIuWFNg:Locale("ja","JP","kansai")<br>
     *         
     * <br>
     * ^ꂽALocale肷B^͌R[h
     * R[hƃoAgR[hłB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale05() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        DBMessage message = new DBMessage("test01", "ja", "JP", "kansai",
                "eXgbZ[WOP");
        ds.defaultLocale = null;
        
        // eXg{
        Locale returnLocale = ds.createLocale(message);

        // 
        assertEquals("ja", returnLocale.getLanguage());
        assertEquals("JP", returnLocale.getCountry());
        assertEquals("kansai", returnLocale.getVariant());
    }

    /**
     * testGetMessages01() <br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() locale:Locale("ja,JP,"")<br>
     * () cachedMergedProperties.get(locale):HashMapo<br>
     * Local(ja_JP)=Properties()<br> p<br>
     * <br>
     * ҒlF(߂l) messages:Properties()<br>
     * (ԕω) cachedMergedProperties.get(locale):w肳ꂽŌĂяo
     * Ă邱ƂmFB<br>
     * <br>
     * L[Ƃă}bvloA̒l߂lƂĕԋp邱
     * mFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetMessages01() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        Locale locale = new Locale("ja", "JP", "");
        Properties props = new Properties();
        ds.cachedMergedProperties.put(locale, props);
        
        // eXg{
        Properties returnProp = ds.getMessages(locale);

        // 
        assertSame(props, returnProp);
                
    }

    /**
     * testGetMessages02() <br>
     * <br>
     * (n) <br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() locale:Locale("ja,JP,"")<br>
     * () cachedMergedProperties.get(locale):HashMap<br>
     * <br>
     * ҒlF(߂l) messages:PropertiesIuWFNg<br>
     * (ԕω) cachedMergedProperties.get(locale):w肳ꂽ
     * ĂяoĂ邱ƂmFB<br>
     * (ԕω) cachedMergedProperties.put(locale,messages):
     * HashMap<Locale,<null,null>><br>
     * <br>
     * L[Ƃă}bvolnullꍇAVɐAi[B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetMessages02() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        Locale locale = new Locale("ja", "JP", "");
        ds.cachedMergedProperties.clear();
        
        // eXg{
        Properties returnProps = ds.getMessages(locale);

        // 
        assertEquals(1, ds.cachedMergedProperties.size());
        Properties result = null;
        result = ds.cachedMergedProperties.get(locale);
        
        assertSame(returnProps, result);         
    }

    /**
     * testResolveCodeWithoutArguments01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA<br>
     * <br>
     * ͒lF() code:"code01"<br>
     * () locale:Locale("ja","JP","")<br>
     * () internalResolveCodeWithoutArguments:"eXgbZ[WOP"<br>
     * <br>
     * ҒlF(߂l) msg:"eXgbZ[WOP"<br>
     * (ԕω) internalResolveCodeWithoutArguments:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     * <br>
     * ^ꂽ胁bZ[W肵AԋpB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testResolveCodeWithoutArguments01() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub04 ds
                = new DataSourceMessageSource_DataSourceMessageSourceStub04();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        String msg = "eXgbZ[WOP";
        ds.msg = msg;
        
        // eXg{
        String returnMsg = ds.resolveCodeWithoutArguments(code, locale);

        // 
        assertEquals(code, ds.code);
        assertSame(locale, ds.locale);
        assertTrue(ds.isRead);
        assertEquals(msg, returnMsg);
    }

    /**
     * testResolveCodeWithoutArguments02() <br>
     * <br>
     * (n)<br>
     * ϓ_FA,C<br>
     * <br>
     * ͒lF() code:"code01"<br>
     * () locale:Locale("ja","JP","")<br>
     * () internalResolveCodeWithoutArguments:null<br>
     * <br>
     * ҒlF(߂l) msg:null<br>
     * (ԕω) internalResolveCodeWithoutArguments:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     * <br>
     * ^ꂽ胁bZ[WłAnullԋpB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testResolveCodeWithoutArguments02() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub04 ds
                = new DataSourceMessageSource_DataSourceMessageSourceStub04();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        
        // eXg{
        String returnMsg = ds.resolveCodeWithoutArguments(code, locale);

        // 
        assertEquals(code, ds.code);
        assertSame(locale, ds.locale);
        assertTrue(ds.isRead);
        assertNull(returnMsg);
    }

    /**
     * testInternalResolveCodeWithoutArguments01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","JP","")<br>
     *         () getMessage().getProperties:"eXgbZ[WOP"<br>
     *         () bZ[Wlocale:Locale("ja",JP","")<br>
     *         () defaultLocale:null<br>
     *         
     * <br>
     * ҒlF(߂l) msg:"eXgbZ[WOP"<br>
     *         (ԕω) getMessage().getProperties:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         
     * <br>
     * w肳ꂽ胁bZ[W肵AԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testInternalResolveCodeWithoutArguments01() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        ds.cachedMergedProperties = null;
        
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        ds.defaultLocale = null;
        
        //cachedMergedProperties
        Map map = new HashMap();
        Properties props = new Properties();
        String msg = "eXgbZ[WOP";
        props.put(code, msg);
        map.put(locale, props);
        ds.cachedMergedProperties = map;
        
        // eXg{
        String returnMsg = ds.internalResolveCodeWithoutArguments(code, locale);
        
        // 
        assertEquals(msg, returnMsg);
    }

    /**
     * testInternalResolveCodeWithoutArguments02() <br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() code:"code01"<br>
     * () locale:Locale("ja","JP","")<br>
     * () getMessage().getProperties:null<br>
     * () bZ[Wlocale:Locale("ja","","")<br>
     * () defaultLocale:null<br>
     * () getAlternativeLocalesij:Listo<br>
     * Localei"ja")<br> p<br>
     * () getMessage(locales.get()).getProperties():1ڂ̖߂l<br>
     * "eXgbZ[WOP"<br>
     * <br>
     * ҒlF(߂l) msg:"eXgbZ[WOP"<br>
     * (ԕω) getMessage().getProperties:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     * (ԕω) getAlternativeLocales:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     * (ԕω)
     * getMessages(locales.get()).getProperties():w肳ꂽŌĂяoĂ邱ƂmFB<br>
     * <br>
     * w肳ꂽŃbZ[WłAVɍ쐬ɂ胁bZ[W肵A
     * ԋpB܂AP[nullłG[ɂȂȂƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testInternalResolveCodeWithoutArguments02() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        ds.defaultLocale = null;
        
        //cachedMergedProperties
        Map map = new HashMap();
        Properties props = new Properties();
        Locale msglocale = new Locale("ja", "", "");
        String msg = "eXgbZ[WOP";
        props.put(code, msg);
        map.put(msglocale, props);
        ds.cachedMergedProperties = map;
        
        // eXg{
        String returnMsg = ds.internalResolveCodeWithoutArguments(code, locale);
        
        // 
        assertEquals("eXgbZ[WOP", returnMsg);
    }

    /**
     * testInternalResolveCodeWithoutArguments03() <br>
     * <br>
     * (n) <br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() code:"code01"<br>
     * () locale:Locale("ja","JP","")<br>
     * () getMessage().getProperties:null<br>
     * () bZ[Wlocale:Locale("en","","")<br>
     * () defaultLocale:Locale("en","US","")<br>
     * () getAlternativeLocalesij:Listo<br>
     * Locale("ja","","")<br>
     * Locale("en","US","")<br>
     * Localei"en","","")<br> p<br>
     * () getMessage(locales.get()).getProperties():Pڂ̖߂l<br>
     * null<br>
     * Qڂ̖߂l<br>
     * null<br>
     * Rڂ̖߂l<br>
     * "eXgbZ[WOP"<br>
     * <br>
     * ҒlF(߂l) msg:"eXgbZ[WOP"<br>
     * (ԕω) getMessage().getProperties:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     * (ԕω) getAlternativeLocales:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     * (ԕω)
     * getMessages(locales.get()).getProperties():w肳ꂽ
     * ĂяoĂ邱ƂmFB<br>
     * <br>
     * w肳ꂽŃbZ[WłAVɍ쐬ɂ
     * bZ[W肵AԋpB܂AP[nullłG[ɂȂȂƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testInternalResolveCodeWithoutArguments03() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();

        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        ds.defaultLocale = new Locale("en", "US", "");
        
        //cachedMergedProperties
        Map map = new HashMap();
        Properties props = new Properties();
        Locale msglocale = new Locale("en", "", "");
        String msg = "eXgbZ[WOP";
        props.put(code, msg);
        map.put(msglocale, props);
        ds.cachedMergedProperties = map;
        
        // eXg{
        String returnMsg = ds.internalResolveCodeWithoutArguments(code, locale);
        
        // 
        assertEquals("eXgbZ[WOP", returnMsg);
    }

    /**
     * testInternalResolveCodeWithoutArguments04() <br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","JP","")<br>
     *         () getMessage().getProperties:null<br>
     *         () bZ[Wlocale:Locale("ja","JP","kansai")<br>
     *         () defaultLocale:Locale("en","US","")<br>
     *         () getAlternativeLocalesij:Listo<br>
     *                  Locale("ja","","")<br>
     *                  Locale("en","US","")<br>
     *                @Localei"en","","")<br>
     *                p<br>
     *         () getMessage(locales.get()).getProperties():Pڂ̖߂l<br>
     *                null<br>
     *                Qڂ̖߂l<br>
     *                null<br>
     *                Rڂ̖߂l<br>
     *                null<br>
     *         
     * <br>
     * ҒlF(߂l) msg:null<br>
     *         (ԕω) getMessage().getProperties:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         (ԕω) getAlternativeLocales:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         (ԕω) getMessages(locales.get()).getProperties():
     *         w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         
     * <br>
     * w肳ꂽyѐVɐAbZ[WłȂꍇnullԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testInternalResolveCodeWithoutArguments04() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        ds.defaultLocale = new Locale("en", "US", "");
        
        //cachedMergedProperties
        Map map = new HashMap();
        Properties props = new Properties();
        Locale msglocale = new Locale("ja", "JP", "kansai");
        String msg = "eXgbZ[WOP";
        props.put(code, msg);
        map.put(msglocale, props);
        ds.cachedMergedProperties = map;
        
        // eXg{
        String returnMsg = ds.internalResolveCodeWithoutArguments(code, locale);
        
        // 
        assertNull(returnMsg);
    }

    /**
     * testInternalResolveCodeWithoutArguments05() <br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","","")<br>
     *         () getMessage().getProperties:null<br>
     *         () bZ[Wlocale:Locale("ja","JP","kansai")<br>
     *         () defaultLocale:null<br>
     *         () getAlternativeLocalesij:Listo<br>
     *                p<br>
     *         
     * <br>
     * ҒlF(߂l) msg:null<br>
     *         (ԕω) getMessage().getProperties:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         (ԕω) getAlternativeLocales:w肳ꂽŌĂяoĂ邱ƂmFB<br>
     *         
     * <br>
     * P[擾łȂꍇAnullԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testInternalResolveCodeWithoutArguments05() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        
        String code = "code01";
        Locale locale = new Locale("ja", "", "");
        ds.defaultLocale = null;
        
        //cachedMergedProperties
        Map map = new HashMap();
        Properties props = new Properties();
        Locale msglocale = new Locale("ja", "JP", "kansai");
        String msg = "eXgbZ[WOP";
        props.put(code, msg);
        map.put(msglocale, props);
        ds.cachedMergedProperties = map;
        
        // eXg{
        String returnMsg = ds.internalResolveCodeWithoutArguments(code, locale);
        
        // 
        assertNull(returnMsg);
    }

    /**
     * testGetAlternativeLocales01() <br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() locale:Locale("ja","","")<br>
     *         () defaultLocale:Locale("en","","")<br>
     *         
     * <br>
     * ҒlF(߂l) locales:vf1List<br>
     *                  Locale{"en","",""}<br>
     *         
     * <br>
     * localeɌR[h݂ȂꍇAVlocalẽp^[
     * ȂB܂AdefaultLocaleɌR[h݂ȂꍇA1p^[localeIuWFNg𐶐AXgɊi[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetAlternativeLocales01() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        Locale locale = new Locale("ja", "", "");
        Locale defaultLocale = new Locale("en", "", "");
        ds.defaultLocale = defaultLocale;
        
        // eXg{
        List locales = ds.getAlternativeLocales(locale);
        
        // 
        assertEquals(1, locales.size());
        assertEquals(defaultLocale, locales.get(0));
    }

    /**
     * testGetAlternativeLocales02() <br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() locale:Locale("ja","JP","")<br>
     *         () defaultLocale:Locale("en","US","")<br>
     *         
     * <br>
     * ҒlF(߂l) locales:vf2List<br>
     *                  Locale{"ja","",""},<br>
     *                  Locale{"en","US",""}<br>
     *                  Locale{"en","",""}<br>
     *         
     * <br>
     * localeɍR[h܂ő݂ꍇA1p^[LocaleIuWFNg
     * B܂AdefaultLocaleɍR[h܂ő݂ꍇA2p^[localeIuWFNg𐶐AXgɊi[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetAlternativeLocales02() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        Locale locale = new Locale("ja", "JP", "");
        Locale defaultLocale = new Locale("en", "US", "");
        ds.defaultLocale = defaultLocale;
        
        Locale locale1 = new Locale("ja", "", "");
        Locale defaultLocale2 = new Locale("en", "", "");
        
        // eXg{
        List locales = ds.getAlternativeLocales(locale);
        
        // 
        assertEquals(3, locales.size());
        assertEquals(locale1, locales.get(0));
        assertEquals(defaultLocale, locales.get(1));
        assertEquals(defaultLocale2, locales.get(2));
    }

    /**
     * testGetAlternativeLocales03() <br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() locale:Locale("ja","JP","kansai")<br>
     *         () defaultLocale:Locale("en","US","NY")<br>
     *         
     * <br>
     * ҒlF(߂l) locales:vf5List<br>
     *                  Locale{"ja","JP",""}<br>
     *                  Locale{"ja","",""}<br>
     *                  Locale{"en","US","NY"}<br>
     *                  Locale{"en","US",""}<br>
     *                  Locale{"en","",""}<br>
     *         
     * <br>
     * localeɃoAgR[h܂ő݂ꍇA2p^[
     * LocaleIuWFNg𐶐B
     * ܂AdefaultLocaleɃoAgR[h܂ő݂ꍇA
     * 3p^[localeIuWFNg𐶐AXgɊi[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetAlternativeLocales03() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        Locale locale = new Locale("ja", "JP", "kansai");
        Locale defaultLocale = new Locale("en", "US", "NY");
        ds.defaultLocale = defaultLocale;
        
        Locale locale1 = new Locale("ja", "JP", "");
        Locale locale2 = new Locale("ja", "", "");
        Locale defaultLocale2 = new Locale("en", "US", "");
        Locale defaultLocale3 = new Locale("en", "", "");

        // eXg{
        List locales = ds.getAlternativeLocales(locale);
        
        // 
        assertEquals(5, locales.size());
        assertEquals(locale1, locales.get(0));
        assertEquals(locale2, locales.get(1));
        assertEquals(defaultLocale, locales.get(2));
        assertEquals(defaultLocale2, locales.get(3));
        assertEquals(defaultLocale3, locales.get(4));     
    }

    /**
     * testGetAlternativeLocales04() <br>
     * <br>
     * (n)<br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() locale:Locale("ja","JP","kansai")<br>
     *         () defaultLocale:Locale("ja","JP","kansai")<br>
     *         
     * <br>
     * ҒlF(߂l) locales:vf2List<br>
     *                  Locale{"ja","JP",""}<br>
     *                  Locale{"ja","",""}<br>
     *         
     * <br>
     * localedefaultLocalelłꍇAlocale
     * VlocaleIuWFNg𐶐AXgɊi[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetAlternativeLocales04() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        Locale locale = new Locale("ja", "JP", "kansai");
        ds.defaultLocale = locale;
        
        Locale locale1 = new Locale("ja", "JP", "");
        Locale locale2 = new Locale("ja", "", "");
 
        // eXg{
        List locales = ds.getAlternativeLocales(locale);
        
        // 
        assertEquals(2, locales.size());
        assertEquals(locale1, locales.get(0));
        assertEquals(locale2, locales.get(1)); 
    }

    /**
     * testGetAlternativeLocales05() <br>
     * <br>
     * (n) <br>
     * ϓ_FF<br>
     * <br>
     * ͒lF() locale:Locale("ja","","")<br>
     *         () defaultLocale:null<br>
     *         
     * <br>
     * ҒlF(߂l) locales:vf0List<br>
     *         
     * <br>
     * defaultLocale̐ݒ肪sĂȂꍇ́AList0ŕԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetAlternativeLocales05() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        Locale locale = new Locale("ja", "", "");
        ds.defaultLocale = null;
        
        // eXg{
        List locales = ds.getAlternativeLocales(locale);
        
        // 
        assertEquals(0, locales.size());
    }
    /**
     * testResolveCode01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA<br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","JP","")<br>
     *         () getMessageFormat(code,locale):"eXgbZ[WOP"<br>
     *         () defaultLocale:null<br>
     *         () bZ[W̃P[:Locale("ja","JP","")<br>
     *         
     * <br>
     * ҒlF(߂l) messageFormat:"eXgbZ[WOP"<br>
     *         (ԕω) getMessageFormat(code,locale):w肳ꂽɂ
     *         ĂяoꂽƂmFB<br>
     *         
     * <br>
     * w肳ꂽ胁bZ[WtH[}bg肵AԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCode01() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        
        //cachedMergedProperties
        Map map = new HashMap();
        Locale formatlocale = new Locale("ja", "JP", "");
        MessageFormat mFormat = new MessageFormat("");
        mFormat.setLocale(formatlocale);
        mFormat.applyPattern("eXgbZ[WOP");
        map.put(formatlocale, mFormat);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat mfreturn = ds.resolveCode(code, locale);
        
        // 
        assertSame(mFormat, mfreturn);
    }

    /**
     * testResolveCode02() <br>
     * <br>
     * (n)<br>
     * ϓ_FA<br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","JP","")<br>
     *         () getMessageFormat(code,locale):null<br>
     *         () defaultLocale:null<br>
     *         () bZ[W̃P[:Locale("ja","","")<br>
     *         () getAlternativeLocalesij:Listo<br>
     *                @Localei"ja")<br>
     *                p<br>
     *         () getMessageFormat(code.locales.get(i)):1ڂ̖߂l<br>
     *                "eXgbZ[WOP"<br>
     *         
     * <br>
     * ҒlF(߂l) messageFormat:"eXgbZ[WOP"<br>
     *         (ԕω) getAlternativeLocale:w肳ꂽɂĂяoꂽ
     *         ƂmFB<br>
     *         (ԕω) getMessageFormat(code,locale):w肳ꂽɂ
     *         ĂяoꂽƂmFB<br>
     *         (ԕω) getMessageFormat(code.locales.get(i)):w肳ꂽ
     *         ĂяoꂽƂmFB<br>
     *         
     * <br>
     * w肳ꂽŃbZ[WtH[}bgłAVɍ쐬
     * 胁bZ[WtH[}bg肵AԋpB
     * ܂AP[nullłG[ɂȂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCode02() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        
        //cachedMergedProperties
        Map map = new HashMap();
        Locale formatlocale = new Locale("ja", "", "");
        MessageFormat mFormat = new MessageFormat("");
        mFormat.setLocale(formatlocale);
        mFormat.applyPattern("eXgbZ[WOP");
        map.put(formatlocale, mFormat);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat mfreturn = ds.resolveCode(code, locale);
        
        // 
        assertSame(mFormat, mfreturn);
    }

    /**
     * testResolveCode03() <br>
     * <br>
     * (n)<br>
     * ϓ_FA<br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","JP","kansai")<br>
     *         () getMessageFormat(code,locale):null<br>
     *         () defaultLocale:Locale("en","","")<br>
     *         () bZ[W̃P[:Locale("en","","")<br>
     *         () getAlternativeLocalesij:Listo<br>
     *                  Locale("ja","JP","")<br>
     *                  Locale("ja","","")<br>
     *                @Localei"en","","")<br>
     *                p<br>
     *         () getMessageFormat(code.locales.get(i)):Pڂ̖߂l<br>
     *                null<br>
     *                Qڂ̖߂l<br>
     *                null<br>
     *                Rڂ̖߂l<br>
     *                "eXgbZ[WOP"<br>
     *         
     * <br>
     * ҒlF(߂l) messageFormat:"eXgbZ[WOP"<br>
     *         (ԕω) getAlternativeLocale:w肳ꂽɂĂяoꂽ
     *         ƂmFB<br>
     *         (ԕω) getMessageFormat(code,locale):w肳ꂽɂ
     *         ĂяoꂽƂmFB<br>
     *         (ԕω) getMessageFormat(code.locales.get(i)):w肳ꂽ
     *         ɂĂяoꂽƂmFB<br>
     *         
     * <br>
     * w肳ꂽŃbZ[WtH[}bgłAVɍ쐬
     * ɂ胁bZ[WtH[}bg肵AԋpB
     * ܂AP[nullłG[ɂȂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCode03() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "kansai");
        Locale defaultLocale = new Locale("en", "", "");
        ds.defaultLocale = defaultLocale;
        
        //cachedMergedProperties
        Map map = new HashMap();
        Locale formatlocale = new Locale("en", "", "");
        MessageFormat mFormat = new MessageFormat("");
        mFormat.setLocale(formatlocale);
        mFormat.applyPattern("eXgbZ[WOP");
        map.put(formatlocale, mFormat);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat mfreturn = ds.resolveCode(code, locale);
        
        // 
        assertSame(mFormat, mfreturn);
    }

    /**
     * testResolveCode04() <br>
     * <br>
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","JP","kansai")<br>
     *         () getMessageFormat(code,locale):null<br>
     *         () defaultLocale:Locale("en","","")<br>
     *         () bZ[W̃P[:Locale("en","US","NY")<br>
     *         () getAlternativeLocalesij:Listo<br>
     *                  Locale("ja","JP","")<br>
     *                  Locale("ja","","")<br>
     *                @Localei"en","","")<br>
     *                p<br>
     *         () getMessageFormat(code.locales.get(i)):Pڂ̖߂l<br>
     *                null<br>
     *                Qڂ̖߂l<br>
     *                null<br>
     *                Rڂ̖߂l<br>
     *                null<br>
     *         
     * <br>
     * ҒlF(߂l) messageFormat:null<br>
     *         (ԕω) getAlternativeLocale:w肳ꂽɂĂяoꂽ
     *         ƂmFB<br>
     *         (ԕω) getMessageFormat(code,locale):w肳ꂽɂ
     *         ĂяoꂽƂmFB<br>
     *         (ԕω) getMessageFormat(code.locales.get(i)):w肳ꂽ
     *         ɂĂяoꂽƂmFB<br>
     *         
     * <br>
     * w肳ꂽyѐVɐAbZ[WtH[}bg
     * łȂꍇnullԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCode04() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "kansai");
        Locale defaultLocale = new Locale("en", "", "");
        ds.defaultLocale = defaultLocale;
        
        //cachedMergedProperties
        Map map = new HashMap();
        Locale formatlocale = new Locale("en", "US", "NY");
        MessageFormat mFormat = new MessageFormat("");
        mFormat.setLocale(formatlocale);
        mFormat.applyPattern("eXgbZ[WOP");
        map.put(formatlocale, mFormat);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat mfreturn = ds.resolveCode(code, locale);
        
        // 
        assertNull(mfreturn);
    }

    /**
     * testResolveCode05() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja","","")<br>
     *         () getMessageFormat(code,locale):null<br>
     *         () defaultLocale:null<br>
     *         () bZ[W̃P[:Locale("en","US","NY")<br>
     *         () getAlternativeLocalesij:Listo<br>
     *                p<br>
     *         
     * <br>
     * ҒlF(߂l) messageFormat:null<br>
     *         (ԕω) getAlternativeLocale:w肳ꂽŌĂяoĂ
     *         ƂmFB<br>
     *         (ԕω) getMessageFormat(code,locale):w肳ꂽ
     *         ĂяoĂ邱ƂmFB<br>
     *         
     * <br>
     * P[擾łȂꍇAnullԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCode05() throws Exception {
        // O
        DataSourceMessageSource ds = new DataSourceMessageSource();
        String code = "code01";
        Locale locale = new Locale("ja", "", "");
        ds.defaultLocale = null;
        
        //cachedMergedProperties
        Map map = new HashMap();
        Locale formatlocale = new Locale("en", "US", "NY");
        MessageFormat mFormat = new MessageFormat("");
        mFormat.setLocale(formatlocale);
        mFormat.applyPattern("eXgbZ[WOP");
        map.put(formatlocale, mFormat);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat mfreturn = ds.resolveCode(code, locale);
        
        // 
        assertNull(mfreturn);
    }

    /**
     * testGetMessageFormat01() <br>
     * <br>
     * (n)<br>
     * ϓ_FA<br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja",JP","")<br>
     *         () cashedMessageFormats:<"code01",<Locale("ja","JP"),
     *         MessageFormat("")>><br>
     *         () bZ[WtH[}bglocale:Locale("ja",JP","")<br>
     *         
     * <br>
     * ҒlF(߂l) result:bZ[WtH[}bgIuWFNg<br>
     *         
     * <br>
     * ɑΉlłɃLbVꂽMapɂAol
     * nullłȂꍇB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetMessageFormat01() throws Exception {
        // O
        DataSourceMessageSource ds 
                = new DataSourceMessageSource();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        MessageFormat mf = new MessageFormat("");
        Map map = new HashMap();
        map.put(locale, mf);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat result = ds.getMessageFormat(code, locale);
        
        // 
        assertSame(mf, result);
    }

    /**
     * testGetMessageFormat02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja",JP","")<br>
     *         () cashedMessageFormats:<"code01",<Locale("ja","JP"),null>><br>
     *         () bZ[WtH[}bglocale:Locale("ja",JP","")<br>
     *         () getMessage(locale):Properties<"code01","eXgbZ[WOP"><br>
     *         
     * <br>
     * ҒlF(߂l) result:bZ[WtH[}bgIuWFNg<br>
     *         
     * <br>
     * ɑΉlłɃLbVꂽMapɂ邪olnullA
     * bZ[W\[XɈɑΉlA
     * bZ[WtH[}bg̐ɐꍇB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetMessageFormat02() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub18 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub18();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        MessageFormat mf = null;
        Map map = new HashMap();
        map.put(locale, mf);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat result = ds.getMessageFormat(code, locale);
        
        // 
        assertSame(mf, result);
        assertTrue(ds.isRead_A1);
    }

    /**
     * testGetMessageFormat03() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja",JP","")<br>
     *         () cashedMessageFormats:<"code01",<Locale("ja","JP"),null><br>
     *         () bZ[WtH[}bglocale:Locale("ja",JP","")<br>
     *         () getMessage(locale):Properties<"abc",""><br>
     *         
     * <br>
     * ҒlF(߂l) result:null<br>
     *         
     * <br>
     * ɑΉlłɃLbVꂽMapɂ邪olnullA
     * bZ[W\[XɈɑΉlȂꍇB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetMessageFormat03() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub19 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub19();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        MessageFormat mf = null;
        Map map = new HashMap();
        map.put(locale, mf);
        ds.cachedMessageFormats.put(code, map);
        
        // eXg{
        MessageFormat result = ds.getMessageFormat(code, locale);
        
        // 
        assertNull(result);
        assertTrue(ds.isRead_A1);
    }


    /**
     * testGetMessageFormat04() <br>
     * <br>
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() code:"code01"<br>
     *         () locale:Locale("ja",JP","")<br>
     *         () cashedMessageFormats:<"code01",null><br>
     *         () bZ[WtH[}bglocale:Locale("ja",JP","")<br>
     *         () getMessage(locale):Properties<"code01","eXgbZ[WOP"><br>
     *         
     * <br>
     * ҒlF(߂l) result:bZ[WtH[}bgIuWFNg<br>
     *         
     * <br>
     * ɑΉlłɃLbVꂽMapɂȂAbZ[W\[X
     * ɈɑΉlAbZ[WtH[}bg̐ɐꍇB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageFormat04() throws Exception {
        // O
        DataSourceMessageSource_DataSourceMessageSourceStub18 ds 
                = new DataSourceMessageSource_DataSourceMessageSourceStub18();
        String code = "code01";
        Locale locale = new Locale("ja", "JP", "");
        ds.cachedMessageFormats.put(code, null);
        MessageFormat mf = new MessageFormat("");
        ds.messageFormat = mf;
        
        ds.cachedMessageFormats.clear();
        
        // eXg{
        MessageFormat result = ds.getMessageFormat(code, locale);
        
        // 
        assertSame(locale, ds.locale);
        assertSame("eXgbZ[WOP", ds.msg);
        assertSame(mf, result);
        
        assertEquals(1, ds.cachedMessageFormats.size());
        Map hm = ds.cachedMessageFormats.get(code);
        assertSame(mf, hm.get(locale));
        assertEquals(1, ds.cachedMessageFormats.size());
        assertTrue(ds.isRead_A1);
        
    }
}
