/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor;

import java.util.Locale;

import jp.terasoluna.fw.oxm.mapper.OXMapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

/**
 * CastorpViewResolverNXB
 * r[󕶎A܂Null̏ꍇACastorr[gpB
 * 
 * <p>DispacherServletɂĕViewResolvergpꍇ邽߁A
 * gpViewResolveȑ`OrderedC^tF[XĂB
 * ȉ̂悤ɁABean`t@Cɂint^{@link #order}ݒ肷ƁA
 * DispacherServlet{@link #order}l̏ViewResolvergpB
 * 
 * <p><strong>Bean`t@C̐ݒ</strong>
 * <pre><code>
 * &lt;!--
 *    CastorpView Resolver
 *  --&gt;
 * &lt;bean id="castorViewResolver" class="jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor.CastorViewResolver"&gt;
 *   &lt;property name="cache"&gt;&lt;value&gt;true&lt;/value&gt;&lt;/property&gt;
 *   &lt;property name="requestContextAttribute"&gt;&lt;value&gt;rc&lt;/value&gt;&lt;/property&gt;
 *   &lt;property name="contentType"&gt;&lt;value&gt;text/xml;charset=UTF-8&lt;/value&gt;&lt;/property&gt;
 *   &lt;property name="order"&gt;&lt;value&gt;2&lt;/value&gt;&lt;/property&gt;
 * &lt;/bean&gt;
 * </code></pre>
 * 
 * @see org.springframework.web.servlet.DispatcherServlet
 */
public class CastorViewResolver extends UrlBasedViewResolver 
    implements Ordered, InitializingBean {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(CastorViewResolver.class);
    
    /**
     * ViewResolverNXgp鏇ԁB
     */
    private int order = Integer.MAX_VALUE;
    
    /**
     * XMLIuWFNgϊNXB
     */
    private OXMapper oxmapper = null;
    
    /**
     * r[NXƂCastorViewNXݒ肷RXgN^B
     */
    public CastorViewResolver() {
        setViewClass(CastorView.class);
    }
    
    /**
     * orderݒ肷B
     * @param order ViewResolverNXgp鏇ԁB
     */
    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    /**
     * order擾B
     * @return ViewResolverNXgp鏇ԁB
     */
    @Override
    public int getOrder() {
        return order;
    }
    
    /**
     * oxmapper擾B
     *
     * @return oxmapper
     */
    public OXMapper getOxmapper() {
        return oxmapper;
    }

    /**
     * oxmapperݒ肷B
     *
     * @param oxmapper oxmapperɐݒ肷l
     */
    public void setOxmapper(OXMapper oxmapper) {
        this.oxmapper = oxmapper;
    }
    
    /**
     * DIReiNA{NXCX^XꂽɌĂ΂郁\bhB
     * OXMapperiIuWFNg|XMLϊNXjݒ肳ĂȂꍇA
     * O𓊂B
     */
    public void afterPropertiesSet() {
        // OXMapperݒ肳ĂȂꍇAOƂ
        if (oxmapper == null) {
            log.error("OXMapper class isn't set in CastorViewResolver. " 
                    + "Check Spring Bean definition file.");
            throw new IllegalStateException(
                    "OXMapper class isn't set in CastorViewResolver. " 
                    + "Check Spring Bean definition file.");
        }   
    }

    /**
     * ׂr[NXԂB
     * @see CastorView
     * @return CastorViewNXB
     */
    @Override
    protected Class requiredViewClass() {
        return CastorView.class;
    }

    /**
     * r[ǂݍށB
     * r[NX̃CX^X{@link #buildView(String)}\bh
     * ϏADIReiɂĈȉ̃\bhĂяoB
     * <ul>
     * <li>ApplicationContextAwareNX<code>setApplicationContext</code>
     * <li>InitializingBeanNX<code>afterPropertiesSet</code>
     * </ul>
     * r[͂ĂꍇANullԂB
     * @see #buildView(String)
     * @see org.springframework.context.ApplicationContextAware#setApplicationContext
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet
     * @param viewName r[
     * @param locale P[
     * @return Castorr[
     * @throws Exception O
     */
    @Override
    protected View loadView(String viewName, Locale locale) throws Exception {
        CastorView view = (CastorView) buildView(viewName);
        
        // CastorView擾łȂꍇANullԂ
        if (view == null) {
            return null;
        }
        
        view.setOxmapper(this.oxmapper);
        view.setApplicationContext(getApplicationContext());
        view.afterPropertiesSet();
        return view;
    }

    /**
     * r[𐶐B
     * r[͂ĂȂꍇ̂݁ACastorr[𐶐B
     * r[͂ĂꍇÃr[gp̂ƔfA
     * NullԂB
     * @param viewName r[
     * @return r[CX^X
     * @throws Exception O
     */
    @Override
    protected AbstractUrlBasedView buildView(String viewName) 
        throws Exception {
        // r[͂ĂꍇANullԂ
        if (StringUtils.hasText(viewName)) {
            return null;
        }
        return super.buildView(viewName);
    }
}
