/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.mapper;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;

import org.w3c.dom.Document;

/**
 * IuWFNg-XMLϊs߂̃C^tF[XB
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.XMLServletRequestDataBinder
 * 
 */
public interface OXMapper {
    /**
     * DOMc[IuWFNgɕϊ郁\bhB
     * @param doc DOMc[
     * @param out ϊΏۂ̃IuWFNg
     */
    void unmarshal(Document doc, Object out);
    
    /**
     * Xg[XMLf[^oAIuWFNgɕϊB
     * @param reader XMLf[^BZbgw肳ĂȂꍇA
     * VM̃ftHgZbggpB
     * @param out XMLϊꂽIuWFNgB
     */
    void unmarshal(Reader reader, Object out);
    
    /**
     * Xg[XMLf[^oAIuWFNgɕϊB
     * @param is XMLf[^B
     * @param argCharset ZbgBNull܂͋󕶎̏ꍇAUTF-8w肳B
     * @param out XMLϊꂽIuWFNgB
     */
    void unmarshal(InputStream is, String argCharset, Object out);

    /**
     * IuWFNgXMLɕϊsAXg[ɏo͂郁\bhB
     * @param in ϊΏۂ̃IuWFNg
     * @param writer C^[
     */
    void marshal(Object in, Writer writer);
}
