/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSString
extends XSPatternBase {
    private static final JType jType = new JClass("java.lang.String");
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$builder$types$XSString == null ? (class$org$exolab$castor$builder$types$XSString = XSString.class$("org.exolab.castor.builder.types.XSString")) : class$org$exolab$castor$builder$types$XSString));
    private int _length = 0;
    private int maxLength = -1;
    private int minLength = 0;
    private String _whiteSpace = "preserve";
    static /* synthetic */ Class class$org$exolab$castor$builder$types$XSString;

    public XSString() {
        super((short)1);
    }

    public String createFromJavaObjectCode(String variableName) {
        return "(String)" + variableName;
    }

    public JType getJType() {
        return jType;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getLength() {
        return this._length;
    }

    public String getWhiteSpace() {
        return this._whiteSpace;
    }

    public boolean hasMaxLength() {
        return this.maxLength >= 0;
    }

    public boolean hasMinLength() {
        return this.minLength > 0;
    }

    public boolean hasLength() {
        return this._length > 0;
    }

    public boolean hasWhiteSpace() {
        return this._whiteSpace != null;
    }

    public void setLength(int length) {
        this._length = length;
        this.setMaxLength(length);
        this.setMinLength(length);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setWhiteSpace(String value) {
        if (value.equals("preserve")) {
            this._whiteSpace = value;
        } else if (value.equals("replace")) {
            this._whiteSpace = value;
        } else if (value.equals("collapse")) {
            this._whiteSpace = value;
        } else {
            LOG.warn((Object)("Warning : " + value + " is a bad entry for the whiteSpace value"));
            this._whiteSpace = value;
        }
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSString.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxLength".equals(name)) {
                this.setMaxLength(facet.toInt());
                continue;
            }
            if ("minLength".equals(name)) {
                this.setMinLength(facet.toInt());
                continue;
            }
            if ("length".equals(name)) {
                this.setLength(facet.toInt());
                continue;
            }
            if ("pattern".equals(name)) {
                this.setPattern(facet.getValue());
                continue;
            }
            if (!"whiteSpace".equals(name)) continue;
            this.setWhiteSpace(facet.getValue());
        }
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("org.exolab.castor.xml.validators.StringValidator typeValidator = new org.exolab.castor.xml.validators.StringValidator();");
        if (this.hasMinLength() && !this.hasLength()) {
            jsc.add("typeValidator.setMinLength(");
            jsc.append(Integer.toString(this.getMinLength()));
            jsc.append(");");
        }
        if (this.hasMaxLength() && !this.hasLength()) {
            jsc.add("typeValidator.setMaxLength(");
            jsc.append(Integer.toString(this.getMaxLength()));
            jsc.append(");");
        }
        if (this.hasLength()) {
            jsc.add("typeValidator.setLength(");
            jsc.append(Integer.toString(this.getLength()));
            jsc.append(");");
        }
        if (this.hasWhiteSpace()) {
            jsc.add("typeValidator.setWhiteSpace(\"");
            jsc.append(this.getWhiteSpace());
            jsc.append("\");");
        }
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator.setPattern(\"");
            jsc.append(XSString.escapePattern(pattern));
            jsc.append("\");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

