/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;

/**
 * Struts̃oO(STR-2172)pHashMap(MessageFormatLbV)B
 * <p>
 * StrutsMessageResourceśALbVgetMessageFormat𓯊ɕXbhŃANZX\ɂĂB<br>
 * ̃oO邽߁ALbV瓯CX^XԂAcloneCX^XԂ悤gĂB<br>
 * ASĂMessageFormat𖳏clonêł͂ȂA
 * 炩ɃXbhAZ[t肪ADateFormatTutH[}bgɎMessageFormat̂݁A
 * getcloneB
 * </p>
 * <p>
 * ̃NX́AStrutsMessageResources̃oOpNXłB<br>
 * put\bh(nulll̐ݒȂ)get\bĥݎgp邱ƂOƂĂB<br>
 * ̑̃\bhgpꍇ́AMapƂĂ͕̓ۏ؂ȂB<br>
 * ܂Aput̖߂lł́AOpuẗœnꂽCX^Xł͂ȂAcloneCX^XԂꍇB
 * (getcloneCX^XԂ𖞂̂ɊYB)
 * </p>
 * @see MessageFormatCacheMapFactory
 */
public class MessageFormatCloneReturnIfUseDateFormatMap
                                                       extends
                                                       HashMap<String, MessageFormat> {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 5766672928587118585L;

    /**
     * getMessageFormatcloneCX^XԂMap
     */
    private MessageFormatCloneReturnMap cloneReturnMap = new MessageFormatCloneReturnMap();

    /**
     * MessageFormatCX^XLbVB
     * @param key MessageFormatLbṼL[
     * @param value LbVMessageFormatCX^X
     * @return \bhsOɃLbVĂMessageFormatCX^X
     */
    @Override
    public MessageFormat put(String key, MessageFormat value) {
        boolean needClone = false;
        for (Format format : value.getFormats()) {
            if (format instanceof DateFormat) {
                needClone = true;
                break;
            }
        }
        if (needClone) {
            return cloneReturnMap.put(key, value);
        }
        return super.put(key, value);
    }

    /**
     * LbVꂽMessageFormatCX^XAKvɉcloneĕԂB
     * @param key MessageFormatLbṼL[
     * @return MessageFormatCX^X
     */
    @Override
    public MessageFormat get(Object key) {
        MessageFormat messageFormat = super.get(key);
        if (messageFormat == null) {
            messageFormat = cloneReturnMap.get(key);
        }
        return messageFormat;
    }
}
