/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;

/**
 * Struts̃oO(STR-2172)pHashMap(MessageFormatLbV)B
 * <p>
 * StrutsMessageResourceśALbVgetMessageFormat𓯊ɕXbhŃANZX\ɂĂB<br>
 * ̃oO邽߁ALbV瓯CX^XԂAcloneCX^XԂ悤gĂB
 * </p>
 * <p>
 * ܂AMessageFormatŎgpTutH[}bg̒ɂ́A
 * (̓Iɂ́A{0,number}̋LqɎgpDecimalFormatYB)
 * cloneȂ΃XbhZ[tł邪A
 * formatscloneƁAMessageFormatCX^X(TutH[}bg̃CX^X܂)
 * XbhƂɑ݂ɂւ炸AXbhAZ[tƂȂ̂B<br>
 * ̃NX́AformatsOput\bhMessageFormatCX^XnOŁA
 * put\bhɂclonesƂŁA̖ĂB<br>
 * </p>
 * <p>
 * ̃NX́AStrutsMessageResources̃oOpNXłB<br>
 * put\bh(nulll̐ݒȂ)get\bĥݎgp邱ƂOƂĂB<br>
 * ̑̃\bhgpꍇ́AMapƂĂ͕̓ۏ؂ȂB
 * ܂Aput̖߂lł́AOpuẗœnꂽCX^Xł͂ȂAcloneCX^XԂB
 * </p>
 * @see MessageFormatCacheMapFactory
 */
public class MessageFormatCloneReturnMap extends HashMap<String, MessageFormat> {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 8965893764397816159L;

    /**
     * MessageFormatCX^XcloneCX^XLbVB
     * @param key MessageFormatLbṼL[
     * @param value LbVMessageFormatCX^X
     * @return \bhsOɃLbVĂMessageFormatCX^X
     */
    @Override
    public MessageFormat put(String key, MessageFormat value) {
        // formatsς݂̂̂cloneƁA
        // XbhAZ[tɂȂtH[}bg݂邽߁A
        // (̓Iɂ́A{0,number}̋LqɎgpDecimalFormatYB)
        // get̖cloneƂ͕ʂɁAputɂA
        // formatsԂMessageFormatcloneăLbVB
        // (œnĂMessageFormat́ÂStrutsMessageResourcesɂformatŝŁA
        //  œnĂMessageFormat̂̓LbVȂ)
        return super.put(key, (MessageFormat) value.clone());
    }

    /**
     * LbVꂽMessageFormatcloneCX^XԂB
     * @param key MessageFormatLbṼL[
     * @return MessageFormatCX^X
     */
    @Override
    public MessageFormat get(Object key) {
        MessageFormat messageFormat = super.get(key);
        if (messageFormat != null) {
            messageFormat = (MessageFormat) messageFormat.clone();
        }
        return messageFormat;
    }
}
