/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.util.ArrayList;
import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFileLineIterator<T>
extends AbstractFileLineIterator<T> {
    private char delimiter = (char)44;
    private char encloseChar = '\u0000';

    public VariableFileLineIterator(String fileName, Class<T> clazz, Map<String, ColumnParser> columnParserMap) {
        super(fileName, clazz, columnParserMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() == '\u0000') {
            throw new FileException("Delimiter can not use '\\u0000'.", new IllegalStateException(), fileName);
        }
        if (fileFormat.lineFeedChar().indexOf(fileFormat.delimiter()) >= 0) {
            throw new FileException("delimiter is the same as lineFeedChar and is no use.", new IllegalStateException(), fileName);
        }
        this.encloseChar = fileFormat.encloseChar();
        this.delimiter = fileFormat.delimiter();
        super.init();
    }

    @Override
    protected String[] separateColumns(String fileLineString) {
        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }
        StringBuilder columnBuilder = new StringBuilder();
        char previousChar = '\u0000';
        ArrayList<String> columnList = new ArrayList<String>();
        boolean isEnclosed = true;
        boolean isEscaped = false;
        int fieldCount = 0;
        char[] columnEncloseChar = this.getColumnEncloseChar();
        if (!this.isEnclosed()) {
            return fileLineString.split(Character.toString(this.delimiter), -1);
        }
        for (char currentChar : fileLineString.toCharArray()) {
            if (previousChar == '\u0000') {
                previousChar = currentChar;
            }
            if (previousChar == columnEncloseChar[fieldCount]) {
                if (isEnclosed) {
                    if (currentChar != columnEncloseChar[fieldCount]) continue;
                    isEnclosed = false;
                    continue;
                }
                if (currentChar == columnEncloseChar[fieldCount]) {
                    if (isEscaped) {
                        columnBuilder.append(currentChar);
                        isEscaped = false;
                        continue;
                    }
                    isEscaped = true;
                    continue;
                }
                if (currentChar == this.getDelimiter()) {
                    if (isEscaped) {
                        columnList.add(columnBuilder.toString());
                        previousChar = '\u0000';
                        columnBuilder.delete(0, columnBuilder.length());
                        isEnclosed = true;
                        isEscaped = false;
                        ++fieldCount;
                        continue;
                    }
                    columnBuilder.append(currentChar);
                    isEscaped = false;
                    continue;
                }
                columnBuilder.append(currentChar);
                continue;
            }
            if (currentChar != this.getDelimiter()) {
                columnBuilder.append(currentChar);
                continue;
            }
            columnList.add(columnBuilder.toString());
            previousChar = '\u0000';
            columnBuilder.delete(0, columnBuilder.length());
            ++fieldCount;
        }
        columnList.add(columnBuilder.toString());
        return columnList.toArray(new String[columnList.size()]);
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public char getEncloseChar() {
        return this.encloseChar;
    }
}

