/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.standard;

import java.util.LinkedHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;

/**
 * L[vZbT}`XbhŎs邽߂̃bp[NXB
 *
 */
public class RunnableQueueProcessor implements Runnable {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(RunnableQueueProcessor.class);

    /**
     * L[vZbTB
     */
    private QueueProcessor queueProcessor = null;

    /**
     * Ώۂi[L[B
     */
    private WorkQueue workQueue = null;

    /**
     * WuXe[^XB
     */
    private JobStatus jobStatus = null;

    /**
     * Onhi[MapB
     */
    private LinkedHashMap<JobException, JobExceptionHandler> 
        exceptionHandlerMap;

    /**
     * ftHgOnhB
     */
    private JobExceptionHandler defaultJobExceptionHandler;

    /**
     * ThrowablenhB
     */
    private ThrowableHandler throwableHandler = null; 

    /**
     * RXgN^B
     * 
     * <p>œnꂽCX^Xݒ肷B</p>
     *
     * @param queueProcessor L[vZbT
     * @param workQueue [NL[
     * @param jobStatus WuXe[^X
     * @param exceptionHandlerMap Onhi[Map
     * @param defaultJobExceptionHandler ftHgOnh
     * @param throwableHandler Throwablenh
     */
    public RunnableQueueProcessor(
            QueueProcessor queueProcessor,
            WorkQueue workQueue,
            JobStatus jobStatus,
            LinkedHashMap<JobException, JobExceptionHandler> 
                exceptionHandlerMap,
            JobExceptionHandler defaultJobExceptionHandler,
            ThrowableHandler throwableHandler) {
        this.queueProcessor = queueProcessor;
        this.workQueue = workQueue;
        this.jobStatus = jobStatus;
        this.exceptionHandlerMap = exceptionHandlerMap;
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
        this.throwableHandler = throwableHandler;
    }

    /**
     * L[vZbTNB
     *
     */
    public void run() {
        try {
            try {
                queueProcessor.process(workQueue, jobStatus);
            } catch (Exception e) {
                try {
                    // BLogicABLogicʃnhŔȌ
                    JobException jobException = new JobException(e);

                    JobExceptionHandler handler = ExceptionHandlerUtil
                            .getJobExceptionHandler(jobException,
                                    exceptionHandlerMap,
                                    defaultJobExceptionHandler);
                    handler.handlException(null, jobException, jobStatus);
                } catch (RuntimeException handlerException) {
                    log.error("[Exception in ExceptionHandler] Error JobID: "
                            + jobStatus.getJobId(), handlerException);
                    jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                }
            }
        } catch (Throwable throwable) {
            throwableHandler.handle(null, throwable, jobStatus);
        }
    }
}
