/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.CollectorResultHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardCollectorResultHandler
implements CollectorResultHandler {
    private static final Log log = LogFactory.getLog(StandardCollectorResultHandler.class);

    public void handle(CollectorResult collectorResult, JobStatus jobStatus) {
        switch (collectorResult.getReturnCode()) {
            case NORMAL_CONTINUE: {
                this.writeInfoLog("Collector processing result code is NORMAL_CONTINUE", jobStatus, collectorResult);
                break;
            }
            case NORMAL_END: {
                this.writeInfoLog("Collector processing result code is NORMAL_END", jobStatus, collectorResult);
                break;
            }
            case ERROR_CONTINUE: {
                this.writeWarnLog("Collector processing result code is ERROR_CONTINUE", jobStatus, collectorResult);
                break;
            }
            case ERROR_END: {
                jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                this.writeErrorLog("Collector processing result code is ERROR_END", jobStatus, collectorResult);
                break;
            }
            default: {
                throw new IllegalArgumentException(collectorResult.getCollected() + " illegal ReturnCode");
            }
        }
    }

    protected void writeInfoLog(String message, JobStatus jobStatus, CollectorResult collectorResult) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder(message);
            logStr.append(" : [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [CollectorResult Info:");
            logStr.append(collectorResult);
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }

    protected void writeErrorLog(String message, JobStatus jobStatus, CollectorResult collectorResult) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [CollectorResult Info:");
        logStr.append(collectorResult);
        logStr.append("]");
        log.error((Object)logStr.toString());
    }

    protected void writeWarnLog(String message, JobStatus jobStatus, CollectorResult collectorResult) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [CollectorResult Info:");
        logStr.append(collectorResult);
        logStr.append("]");
        log.warn((Object)logStr.toString());
    }
}

