/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.controlbreak;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.openapi.ControlBreakHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBreakDef {
    private static final Log log = LogFactory.getLog(ControlBreakDef.class);
    private List<ControlBreakDefItem> controlBreakDefItemList = null;
    private ControlBreakDefItem chunkControlBreakDefItem = null;
    private List<ControlBreakDefItem> transChunkControlBreakDefItemList = null;

    public final void init() {
        int i;
        List<String> chunkBreakKeyList = null;
        if (this.chunkControlBreakDefItem == null || this.chunkControlBreakDefItem.getBreakKey().size() == 0 && this.chunkControlBreakDefItem.getControlBreakHandler() == null) {
            if (this.transChunkControlBreakDefItemList != null && this.transChunkControlBreakDefItemList.size() != 0) {
                throw new InitializeException("TransChunkControlBreakDefItemList setup of ChunkControlBreakDefItem is required to set up TransChunkControlBreakDefItemList.");
            }
        } else {
            chunkBreakKeyList = this.chunkControlBreakDefItem.getBreakKey();
            if (this.existSameKeyInBreakKeyList(chunkBreakKeyList)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("illegal ChunkControlBreakKeys: " + this.showBreakList(chunkBreakKeyList)));
                }
                throw new InitializeException("ChunkControlBreakKey is illegal.");
            }
        }
        if (chunkBreakKeyList != null && this.transChunkControlBreakDefItemList != null) {
            this.sortControlBreakDefItemListByBreakKeyCount(this.transChunkControlBreakDefItemList);
            for (i = 0; i < this.transChunkControlBreakDefItemList.size(); ++i) {
                List<String> checkTransBreakKeyList = this.transChunkControlBreakDefItemList.get(i).getBreakKey();
                if (this.existSameKeyInBreakKeyList(checkTransBreakKeyList)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("illegal TransChunkControlBreakKey: " + this.showBreakList(checkTransBreakKeyList)));
                    }
                    throw new InitializeException("TransChunkControlBreakKey is illegal.");
                }
                if (this.isOutOfRelativeBreakRange(checkTransBreakKeyList, chunkBreakKeyList)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("illegal TransChunkControlBreakKey: " + this.showBreakList(checkTransBreakKeyList) + " ,Or ChunkControlBreakKey: " + this.showBreakList(chunkBreakKeyList)));
                    }
                    throw new InitializeException("It is necessary to define TransChunkControlBreakDefItemList within the limits of ChunkControlBreakDefItem.");
                }
                if (i + 1 >= this.transChunkControlBreakDefItemList.size()) continue;
                List<String> nextTranceBreakKeyList = this.transChunkControlBreakDefItemList.get(i + 1).getBreakKey();
                this.checkNextBreakKeyList(checkTransBreakKeyList, nextTranceBreakKeyList, "TransChunkControlBreak");
            }
        }
        if (this.controlBreakDefItemList != null) {
            this.sortControlBreakDefItemListByBreakKeyCount(this.controlBreakDefItemList);
            for (i = 0; i < this.controlBreakDefItemList.size(); ++i) {
                List<String> checkControlBreakKeyList = this.controlBreakDefItemList.get(i).getBreakKey();
                if (this.existSameKeyInBreakKeyList(checkControlBreakKeyList)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("illegal ControlBreakKey: " + this.showBreakList(checkControlBreakKeyList)));
                    }
                    throw new InitializeException("ControlBreakKey is illegal.");
                }
                if (chunkBreakKeyList != null && this.isOutOfRelativeBreakRange(chunkBreakKeyList, checkControlBreakKeyList)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("illegal ControlBreakKey: " + this.showBreakList(checkControlBreakKeyList) + " ,Or ChunkControlBreakKey: " + this.showBreakList(chunkBreakKeyList)));
                    }
                    throw new InitializeException("It is necessary to define ChunkControlBreakDefItem within the limits of ControlBreakDefItemList.");
                }
                if (i + 1 >= this.controlBreakDefItemList.size()) continue;
                List<String> nextControlBreakKeyList = this.controlBreakDefItemList.get(i + 1).getBreakKey();
                this.checkNextBreakKeyList(checkControlBreakKeyList, nextControlBreakKeyList, "ControlBreak");
            }
        }
    }

    private void sortControlBreakDefItemListByBreakKeyCount(List<ControlBreakDefItem> itemList) {
        Collections.sort(itemList, new Comparator<ControlBreakDefItem>(){

            @Override
            public int compare(ControlBreakDefItem item1, ControlBreakDefItem item2) {
                return item2.getBreakKey().size() - item1.getBreakKey().size();
            }
        });
    }

    private boolean existSameKeyInBreakKeyList(List<String> keyList) {
        HashSet<String> checkKeyList = new HashSet<String>();
        for (int k = 0; k < keyList.size(); ++k) {
            if (checkKeyList.contains(keyList.get(k))) {
                return true;
            }
            checkKeyList.add(keyList.get(k));
        }
        return false;
    }

    private void checkNextBreakKeyList(List<String> checkKeyList, List<String> nextKeyList, String breakRank) {
        if (nextKeyList != null) {
            if (this.isOutOfRelativeBreakRange(nextKeyList, checkKeyList)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("illegal " + breakRank + "Key: " + this.showBreakList(checkKeyList) + " ,Or Another " + breakRank + "Key: " + this.showBreakList(nextKeyList)));
                }
                throw new InitializeException("A setup of a " + breakRank + "Key needs to be an inclusive" + " relation.");
            }
            if (checkKeyList.size() == nextKeyList.size()) {
                throw new InitializeException("Two or more " + breakRank + " cannot be defined" + " as the same Break key.");
            }
        }
    }

    private boolean isOutOfRelativeBreakRange(List<String> largeBreakRangeKeyList, List<String> smallBreakRangeKeyList) {
        for (int k = 0; k < largeBreakRangeKeyList.size(); ++k) {
            if (smallBreakRangeKeyList.contains(largeBreakRangeKeyList.get(k))) continue;
            return true;
        }
        return false;
    }

    public ControlBreakDefItem getChunkControlBreakDefItem() {
        return this.chunkControlBreakDefItem;
    }

    public void setChunkControlBreakDefItem(ControlBreakDefItem chunkControlBreakDefItem) {
        this.chunkControlBreakDefItem = chunkControlBreakDefItem;
    }

    public List<ControlBreakDefItem> getControlBreakDefItemList() {
        return this.controlBreakDefItemList;
    }

    public final void setControlBreakDefItemList(List<ControlBreakDefItem> controlBreakDefItemList) {
        this.controlBreakDefItemList = controlBreakDefItemList;
    }

    public List<ControlBreakDefItem> getTransChunkControlBreakDefItemList() {
        return this.transChunkControlBreakDefItemList;
    }

    public final void setTransChunkControlBreakDefItemList(List<ControlBreakDefItem> transChunkControlBreakDefItemList) {
        this.transChunkControlBreakDefItemList = transChunkControlBreakDefItemList;
    }

    public ControlBreakHandler<JobContext> getTransChunkControlBreakHandler(List<String> transChunkControlBreakkey) {
        if (transChunkControlBreakkey == null || transChunkControlBreakkey.size() == 0) {
            throw new NullPointerException("TransChunkControlBreakkey is Null");
        }
        if (this.transChunkControlBreakDefItemList == null || this.transChunkControlBreakDefItemList.size() == 0) {
            throw new IllegalArgumentException("ControlBreakHandler not found: " + transChunkControlBreakkey.toString());
        }
        for (ControlBreakDefItem controlBreakDefItem : this.transChunkControlBreakDefItemList) {
            if (!((Object)controlBreakDefItem.getBreakKey()).equals(transChunkControlBreakkey)) continue;
            return controlBreakDefItem.getControlBreakHandler();
        }
        throw new IllegalArgumentException("ControlBreakHandler not found: " + transChunkControlBreakkey.toString());
    }

    public ControlBreakHandler<JobContext> getControlBreakHandler(List<String> controlBreakkey) {
        if (controlBreakkey == null || controlBreakkey.size() == 0) {
            throw new NullPointerException("ControlBreakkey is Null");
        }
        if (this.controlBreakDefItemList == null || this.controlBreakDefItemList.size() == 0) {
            throw new IllegalArgumentException("ControlBreakHandler not found: " + controlBreakkey.toString());
        }
        for (ControlBreakDefItem controlBreakDefItem : this.controlBreakDefItemList) {
            if (!((Object)controlBreakDefItem.getBreakKey()).equals(controlBreakkey)) continue;
            return controlBreakDefItem.getControlBreakHandler();
        }
        throw new IllegalArgumentException("ControlBreakHandler not found: " + controlBreakkey.toString());
    }

    private String showBreakList(List<String> keyList) {
        StringBuffer data = new StringBuffer();
        data.append("{");
        for (int i = 0; i < keyList.size(); ++i) {
            data.append(keyList.get(i));
            if (i >= keyList.size() - 1) continue;
            data.append(", ");
        }
        data.append("}");
        return data.toString();
    }
}

