/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
 */
public class LineFeed1LineReader implements LineReader {

    /**
     * t@CANZXp̕Xg[B
     */
    private Reader reader = null;

    /**
     * s؂蕶B
     */
    private String lineFeedChar = null;

    /**
     * RXgN^B
     * @param reader t@CANZXp̕Xg[
     * @param lineFeedChar s؂蕶
     * @throws IllegalArgumentException ̐ݒ肪ԈꍇB
     */
    public LineFeed1LineReader(Reader reader, String lineFeedChar) {

        if (reader == null) {
            throw new IllegalArgumentException("reader is required.");
        }

        if (lineFeedChar == null) {
            throw new IllegalArgumentException("lineFeedChar is required.");
        }

        if (lineFeedChar.length() != 1) {
            throw new IllegalArgumentException("lineFeedChar should be defined"
                    + " by 1 digit of character string.");
        }

        this.reader = reader;
        this.lineFeedChar = lineFeedChar;
    }

    /**
     * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
     * @return f[^̂Ps̕
     * @throws FileException ReadeȑŗOꍇB
     */
    public String readLine() {
        StringBuilder currentLineStringBuilder = new StringBuilder();

        // `FbNΏە
        char currentChar = Character.MIN_VALUE;

        // s؂蕶1ځB
        char lineFeedChar1 = lineFeedChar.charAt(0);

        int chr = 0;

        try {
            while ((chr = reader.read()) != -1) {
                currentChar = (char) chr;
                if (currentChar == lineFeedChar1) {
                    break;
                }
                currentLineStringBuilder.append(currentChar);
            }
        } catch (IOException e) {
            throw new FileException("Reader control operation was failed.", e);
        }

        return currentLineStringBuilder.toString();
    }

}
