/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
 */
public class LineFeed0LineReader implements LineReader {

    /**
     * t@CANZXp̕Xg[B
     */
    private Reader reader = null;

    /**
     * t@CGR[fBO
     */
    private String fileEncoding = null;

    /**
     * 1s̃oCg
     */
    private int totalBytes = 0;

    /**
     * RXgN^B
     * @param reader t@CANZXp̕Xg[
     * @param fileEncoding t@CGR[fBO
     * @param totalBytes 1s̃oCg
     * @throws IllegalArgumentException ̐ݒ肪ԈꍇB
     */
    public LineFeed0LineReader(Reader reader, String fileEncoding,
            int totalBytes) {

        if (reader == null) {
            throw new IllegalArgumentException("reader is required.");
        }

        if (fileEncoding == null) {
            throw new IllegalArgumentException("fileEncoding is required.");
        }

        if (totalBytes <= 0) {
            throw new IllegalArgumentException("totalBytes is larger than 0.");
        }

        this.reader = reader;
        this.fileEncoding = fileEncoding;
        this.totalBytes = totalBytes;
    }

    /**
     * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
     * @return f[^̂Ps̕
     * @throws FileException ReadeȑŗOꍇB
     */
    public String readLine() {
        StringBuilder currentLineStringBuilder = new StringBuilder();

        int chr = 0;
        int size = 0;

        try {
            while ((chr = reader.read()) != -1) {
                char currentChar = (char) chr;
                currentLineStringBuilder.append(currentChar);

                size += Character.toString(currentChar).getBytes(fileEncoding).length;

                if (size >= totalBytes) {
                    break;
                }
            }
        } catch (IOException e) {
            throw new FileException("Reader control operation was failed.", e);
        }

        return currentLineStringBuilder.toString();
    }

}
