/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.validation;

import jp.terasoluna.fw.batch.core.CollectedDataHandler;

import org.springframework.validation.BindException;
import org.springframework.validation.Validator;

/**
 * ̓`FbNspAΏۃf[^̃nhNXB
 * 
 * <p>̓`FbNAΏۃf[^p`N쐬B</p>
 *
 */
public class ValidationExecutor implements CollectedDataHandler {

    /**
     * of[^B
     */
    private Validator validator = null;
    
    /**
     * of[^ʃnhB
     */
    private ValidationResultHandler validationResultHandler = null;

    /**
     * Ώۃf[^p`N쐬pNXB
     */
    private CollectedDataHandler collectedDataHandler = null;
    
    /**
     * RXgN^B
     * 
     * @param collectedDataHandler Ώۃf[^p`N쐬pNX
     * @param validator of[^
     * @param validationResultHandler of[^ʃnh
     */
    public ValidationExecutor(CollectedDataHandler collectedDataHandler,
            Validator validator, 
            ValidationResultHandler validationResultHandler) {
        this.collectedDataHandler = collectedDataHandler;
        this.validator = validator;
        this.validationResultHandler = validationResultHandler;
    }
    
    /**
     * ̓`FbNAΏۃf[^L[ɒǉB
     * of[^ʃnh<code>false</code>ԋpꂽꍇ̓L[ւ
     * ǉ͍sȂB
     *
     * @param collectedData Ώۃf[^
     * @param index Ώۃf[^̃CfbNX
     */
    public void handle(Object collectedData, int index) {
        BindException bindException = new BindException(collectedData,
                collectedData.getClass().getName());
        validator.validate(collectedData, bindException);
        
        if (validationResultHandler.handle(bindException, collectedData)) {
            collectedDataHandler.handle(collectedData, index);
        }
    }

    /**
     * N[YsB
     *
     */
    public void close() {
        collectedDataHandler.close();
    }
}
