/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.restart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * X^[g擾EXVpNXB
 * 
 * <li><code>jobRestart-sqlMap.xml</code>ɒ`ꂽȉ<code>SQL</code>sB</li>
 * 
 * <pre><code>
 *         &lt;!-- X^[gXViXVj --&gt;
 *         &lt;update id=&quot;UPDATE_JOB_RESTART_POINT&quot; parameterClass=&quot;jobRestartInfo&quot;&gt;
 *             UPDATE RESTART_CONTROL SET 
 *                 RESTART_POINT = #restartPoint# , 
 *                 JOB_CONTEXT   = #jobContext#, 
 *                 STATE         = #state#, 
 *                 UPDATE_TIME   = current_timestamp 
 *             WHERE REQUEST_NO  = #requestNo# 
 *             AND  JOB_ID       = #jobId#  
 *             AND  PARTITION_NO = #partitionNo#
 *         &lt;/update&gt;
 *     
 *         &lt;!-- X^[gXViVKǉj --&gt;
 *         &lt;insert id=&quot;INSERT_JOB_RESTART_POINT&quot; parameterClass=&quot;jobRestartInfo&quot;&gt;
 *             INSERT INTO RESTART_CONTROL 
 *                   (REQUEST_NO   , JOB_ID   , PARTITION_NO   , PARTITION_KEY   , RESTART_POINT   , JOB_CONTEXT   , STATE , UPDATE_TIME       , REGISTER_TIME) 
 *             VALUES(#requestNo# , #jobId# , #partitionNo# , #partitionKey# , #restartPoint# , #jobContext# , #state#   , current_timestamp , current_timestamp) 
 *         &lt;/insert&gt;
 *     
 *      X^[gNApSQL͈ȉ̓I邱ƂoB
 *      ftHgSQL͑Ώۃf[^폜łB
 *         &lt;!-- X^[gNAiΏۃf[^̏ԍXVj --&gt;
 *         &lt;update id=&quot;UPDATE_JOB_RESTART_CLEAR&quot; parameterClass=&quot;jobRestartInfo&quot;&gt;
 *             UPDATE RESTART_CONTROL SET 
 *                 STATE       = #state# , 
 *                 UPDATE_TIME = current_timestamp 
 *             WHERE REQUEST_NO   = #requestNo# 
 *             AND   JOB_ID       = #jobId#  
 *             AND   PARTITION_NO = #partitionNo#
 *         &lt;/update&gt;
 *         &lt;!-- X^[gNAiΏۃf[^폜j --&gt;
 *         &lt;delete id=&quot;UPDATE_JOB_RESTART_CLEAR&quot; parameterClass=&quot;jobRestartInfo&quot;&gt;
 *             DELETE FROM RESTART_CONTROL 
 *             WHERE REQUEST_NO   = #requestNo# 
 *             AND   JOB_ID       = #jobId#  
 *             AND   PARTITION_NO = #partitionNo#
 *         &lt;/delete&gt;
 *     
 *         &lt;!-- X^[g˗擾 --&gt;
 *         &lt;select id=&quot;SELECT_JOB_RESTART_INFO&quot; parameterClass=&quot;jobRestartInfo&quot; resultClass=&quot;jobRestartInfo&quot;&gt;
 *             SELECT REQUEST_NO AS requestNo, 
 *                    JOB_ID as jobId, 
 *                    PARTITION_KEY as partitionKey, 
 *                    RESTART_POINT as restartPoint, 
 *                    JOB_CONTEXT as jobContext, 
 *                    STATE as state, 
 *                    UPDATE_TIME,
 *                    REGISTER_TIME as registerTime 
 *             FROM RESTART_CONTROL 
 *             WHERE REQUEST_NO    = #requestNo# 
 *             AND   JOB_ID        = #jobId#  
 *             AND   PARTITION_NO  = #partitionNo#
 *             AND   STATE         = #state#
 *         &lt;/select&gt;
 * </code></pre>
 * 
 */
public class JobRestartTableHandler {

    
    /**
     * X^[g󋵁FB
     */
    private static final String JOB_END_STATE = "2";

    /**
     * X^[g󋵁FNB
     */
    private static final String JOB_START_STATE = "1";

    /**
     * X^[gXViVKǉjpSQLL[B
     */
    private static final String INSERT_JOB_RESTART_POINT = 
        "jobRestart.INSERT_JOB_RESTART_POINT";

    /**
     * X^[gXViXVjpSQLL[B
     */
    private static final String UPDATE_JOB_RESTART_POINT = 
        "jobRestart.UPDATE_JOB_RESTART_POINT";

    /**
     * WuX^[gi[pObjectB SpringDI@\pĐݒ肷B
     */
    private JobRestartInfoFactory jobRestartInfoFactory = null;

    /**
     * SELECTpDAOB SpringDI@\pĐݒ肷B
     */
    private QueryDAO queryDAO = null;

    /**
     * UPDATEpDAOB SpringDI@\pĐݒ肷B
     */
    private UpdateDAO updateDAO = null;

    /**
     * WuReLXgB
     * 
     * @param jobContext WuReLXg
     * @param jobStatus WuXe[^X
     * @return ꂽWuReLXg
     */
    public JobContext getRestartJobContext(JobContext jobContext,
            JobStatus jobStatus) {
        // WuX^[g擾
        JobRestartInfo jobRestartInfo = jobRestartInfoFactory.getInstance();
        initJobRestartInfo(jobRestartInfo, jobContext, jobStatus);
        // Ώۂ͋N̒fꂽf[^̂
        jobRestartInfo.setState(JOB_START_STATE);
        // DB烊X^[g擾
        JobRestartInfo restoreJobRestartInfo = queryDAO.executeForObject(
                "jobRestart.SELECT_JOB_RESTART_INFO", jobRestartInfo,
                JobRestartInfo.class);

        if (restoreJobRestartInfo == null) {
            // X^[gł͂ȂB
            jobContext.setRestarted(false);
            jobStatus.setJobState(JobStatus.STATE.STARTED);
            return jobContext;
        } else if (JOB_END_STATE.equals(restoreJobRestartInfo.getState())) {
            // IB
            jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
            return jobContext;
        }
        
        JobContext newjobContext = 
            changeByteToJobContext(restoreJobRestartInfo.getJobContext());
        newjobContext.setRestartPoint(restoreJobRestartInfo.getRestartPoint());
        jobStatus.setRestartPoint(restoreJobRestartInfo.getRestartPoint());
        // X^[głB
        newjobContext.setRestarted(true);
        jobStatus.setJobState(JobStatus.STATE.RESTARTED);
        
        return newjobContext;
    }

    /**
     * X^[g|CgXVB
     * 
     * @param jobStatus
     *            Wȕ
     * @param jobContext
     *            WuReLXg
     */
    public void registerRestartPoint(JobContext jobContext,
            JobStatus jobStatus) {
        if (!jobStatus.isRestartable()) {
            return;
        }

        JobRestartInfo jobRestartInfo = jobRestartInfoFactory.getInstance();
        initJobRestartInfo(jobRestartInfo, jobContext, jobStatus);
        jobRestartInfo.setRestartPoint(jobStatus.getRestartPoint());
        jobRestartInfo.setState(JOB_START_STATE);

        // R~bgȌꍇ̓X^[g|CgVKǉ
        if (queryDAO.executeForObject("jobRestart.SELECT_JOB_RESTART_INFO",
                jobRestartInfo, JobRestartInfo.class) != null) {
            updateRestartPoint(jobRestartInfo);
        } else {
            // X^[g̒ǉ
            insertRestartPoint(jobRestartInfo);
        }
    }

    /**
     * WuX^[gi[pNX̃t@Ngݒ肷B
     * 
     * @param jobRestartInfoFactory
     *            WuX^[gi[pNX̃t@Ng
     */
    public void setJobRestartInfoFactory(
            JobRestartInfoFactory jobRestartInfoFactory) {
        this.jobRestartInfoFactory = jobRestartInfoFactory;
    }

    /**
     * SELECTpDAÕZb^[B
     * 
     * @param queryDAO
     *            SELECTpDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * XVpDAÕZb^[B
     * 
     * @param updateDAO
     *            XVpDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /**
     * X^[g̃NAp\bh(R[hXV)B
     * 
     * @param jobStatus Wu
     * @param sqlkey X^[g̃NApSQLL[
     * @return XVꂽR[hB
     */
    public int restartPointClear(JobStatus jobStatus, String sqlkey) {
        JobRestartInfo jobRestartInfo = jobRestartInfoFactory.getInstance();
        jobRestartInfo.setRequestNo(jobStatus.getJobRequestNo());
        jobRestartInfo.setJobId(jobStatus.getJobId());
        jobRestartInfo.setPartitionNo(jobStatus.getPartitionNo());
        jobRestartInfo.setState(JOB_END_STATE);

        // X^[g̃NA
        return updateDAO.execute(sqlkey, jobRestartInfo);
    }

    /**
     * Wu󋵁AWuReLXg̃f[^XVΏۂ̃X^[g
     * ݒ肷B<BR>
     * ȉ̏ݒ肷B<BR>
     * WuNGXgԍAWuIDAp[eBVԍA p[eBVL[A
     * WuReLXgibyte[]ɕϊݒj
     * 
     * 
     * @param jobRestartInfo
     *            XVΏۂ̃X^[g
     * @param jobContext
     *            WuReLXg
     * @param jobStatus
     *            Wu
     */
    protected void initJobRestartInfo(JobRestartInfo jobRestartInfo,
            JobContext jobContext, JobStatus jobStatus) {
        if (jobContext == null) {
            throw new IllegalArgumentException("JobContext is NULL");
        }
        jobRestartInfo.setRequestNo(jobStatus.getJobRequestNo());
        jobRestartInfo.setJobId(jobStatus.getJobId());
        jobRestartInfo.setPartitionNo(jobStatus.getPartitionNo());
        jobRestartInfo.setPartitionKey(jobStatus.getPartitionKey());
        jobRestartInfo.setJobContext(changeJobContextToByte(jobContext));
    }

    /**
     * WuReLXgIuWFNg<code>byte</code>zɕϊB<BR>
     * 
     * @param jobContext
     *            WuReLXg
     * @return WuReLXg̃oCgzB
     */
    protected byte[] changeJobContextToByte(JobContext jobContext) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(jobContext);
        } catch (IOException e) {
            throw new JobException(e);
        }
        return byteOut.toByteArray();
    }
        
    /**
     * <code>byte</code>zWuReLXgIuWFNgɕϊB<BR>
     * 
     * @param obj ϊΏۂObject
     * @return WuReLXgB
     */
    protected JobContext changeByteToJobContext(byte[] obj) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(obj);
            ObjectInputStream in = new ObjectInputStream(byteIn);
            return (JobContext) in.readObject();
        } catch (IOException e) {
            throw new JobException(e);
        } catch (ClassNotFoundException e) {
            throw new JobException(e);
        }
    }

    /**
     * X^[ǵuN󋵁vXVp\bhB
     * 
     * @param jobRestartInfo
     *            XVΏۂ̃X^[g
     * @return int XVꂽR[hB
     */
    private int insertRestartPoint(JobRestartInfo jobRestartInfo) {
        return updateDAO.execute(INSERT_JOB_RESTART_POINT, jobRestartInfo);
    }

    /**
     * X^[ǵuN󋵁vXVp\bhB
     * 
     * @param jobRestartInfo
     *            XVΏۂ̃X^[g
     * @return int XVꂽR[hB
     */
    private int updateRestartPoint(JobRestartInfo jobRestartInfo) {
        return updateDAO.execute(UPDATE_JOB_RESTART_POINT, jobRestartInfo);
    }
}
