/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectedDataHandlerFactory;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * gUNViRg[uCNPʂɃ`N쐬
 * <code>ControlBreakChunker</code> 𐶐NXB
 * 
 */
public class ControlBreakChunkerFactory 
    implements CollectedDataHandlerFactory {

    /**
     * Rg[uCN̒`B
     */
    private ControlBreakDef controlBreakDef = null;
    
    /**
     * `NTCYB
     */
    private int chunkSize = 20;
    
    /**
     * gUNViRg[uCNPʂɃ`N쐬
     * <code>ControlBreakChunker</code> 𐶐B
     * 
     * @param workQueue [NL[
     * @param jobContext WuReNXg
     * @return gUNViRg[uCNPʂɃ`N쐬
     * `J[
     */
    public CollectedDataHandler getHandler(WorkQueue workQueue,
            JobContext jobContext) {
        return new ControlBreakChunker(workQueue, jobContext, controlBreakDef,
                chunkSize);
    }

    /**
     * Rg[uCN̒`ݒ肷B
     * 
     * @param controlBreakDef Rg[uCN̒`
     */
    public void setControlBreakDef(ControlBreakDef controlBreakDef) {
        this.controlBreakDef = controlBreakDef;
    }
    
    /**
     * `NTCYݒ肷B
     * 
     * @param chunkSize `NTCY
     */
    public void setChunkSize(int chunkSize) {
        if (chunkSize > 0) {
            this.chunkSize = chunkSize;
        }
    }
}
