/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.message;

import java.util.List;
import javax.sql.DataSource;
import jp.terasoluna.fw.message.DBMessage;
import jp.terasoluna.fw.message.DBMessageQuery;
import jp.terasoluna.fw.message.DBMessageResourceDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBMessageResourceDAOImpl
extends JdbcDaoSupport
implements DBMessageResourceDAO {
    protected String tableName = "MESSAGES";
    protected String codeColumn = "CODE";
    protected String languageColumn = null;
    protected String countryColumn = null;
    protected String variantColumn = null;
    protected String messageColumn = "MESSAGE";
    protected String findMessageSql = null;
    private static Log log = LogFactory.getLog(DBMessageResourceDAOImpl.class);
    protected DBMessageQuery dBMessageQuery = null;

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCodeColumn(String codeColumn) {
        this.codeColumn = codeColumn;
    }

    public void setLanguageColumn(String languageColumn) {
        this.languageColumn = languageColumn;
    }

    public void setCountryColumn(String countryColumn) {
        this.countryColumn = countryColumn;
    }

    public void setVariantColumn(String variantColumn) {
        this.variantColumn = variantColumn;
    }

    public void setMessageColumn(String messageColumn) {
        this.messageColumn = messageColumn;
    }

    public void setFindMessageSql(String findMessageSql) {
        this.findMessageSql = findMessageSql;
    }

    protected DBMessageResourceDAOImpl() {
    }

    protected void initDao() {
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            log.error((Object)"Missing dataSource in spring configuration file.");
            throw new IllegalArgumentException("Missing dataSource in spring configuration file.");
        }
        this.dBMessageQuery = new DBMessageQuery(dataSource, this.makeSql(), this.codeColumn, this.languageColumn, this.countryColumn, this.variantColumn, this.messageColumn);
    }

    @Override
    public List<DBMessage> findDBMessages() {
        return this.dBMessageQuery.execute();
    }

    protected String makeSql() {
        this.checkRequiredColumnName(this.codeColumn, "codeColumn");
        this.checkNotRequiredColumnName(this.languageColumn, "languageColumn");
        this.checkNotRequiredColumnName(this.countryColumn, "countryColumn");
        this.checkNotRequiredColumnName(this.variantColumn, "variantColumn");
        this.checkRequiredColumnName(this.messageColumn, "messageColumn");
        this.checkRequiredColumnName(this.tableName, "tableName");
        StringBuilder sql = null;
        if (this.findMessageSql != null) {
            sql = new StringBuilder(this.findMessageSql);
        } else {
            sql = new StringBuilder("SELECT ");
            sql.append(this.codeColumn);
            sql.append(",");
            if (this.languageColumn != null) {
                sql.append(this.languageColumn);
                sql.append(",");
            }
            if (this.countryColumn != null) {
                sql.append(this.countryColumn);
                sql.append(",");
            }
            if (this.variantColumn != null) {
                sql.append(this.variantColumn);
                sql.append(",");
            }
            sql.append(this.messageColumn);
            sql.append(" FROM ");
            sql.append(this.tableName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql + "]"));
        }
        return sql.toString();
    }

    protected void checkRequiredColumnName(String value, String columnName) {
        if (value == null || "".equals(value)) {
            log.error((Object)("illegalArgument: " + columnName + " is null or empty."));
            throw new IllegalArgumentException("illegalArgument: " + columnName + " is null or empty.");
        }
    }

    protected void checkNotRequiredColumnName(String value, String columnName) {
        if ("".equals(value)) {
            log.error((Object)("illegalArgument: " + columnName + " is empty."));
            throw new IllegalArgumentException("illegalArgument: " + columnName + " is empty.");
        }
    }
}

