/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.partition;

import jp.terasoluna.fw.batch.core.JobManager;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkQueueFactory;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequentialChildJobManager
extends JobManager {
    private static final Log log = LogFactory.getLog(SequentialChildJobManager.class);
    private WorkQueueFactory workQueueFactory = null;
    private String name = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();
    private SupportProcessor preProcessor = null;
    private SupportProcessor postProcessor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work(WorkUnit workUnit, JobStatus jobStatus) {
        JobStatus childJobStatus = null;
        childJobStatus = jobStatus.getChild(workUnit.getJobContext());
        boolean finish_flag = true;
        try {
            this.writeStartLog(childJobStatus);
            this.preProcessor.process(workUnit.getJobContext(), childJobStatus);
            if (!childJobStatus.isContinue()) {
                finish_flag = false;
                return;
            }
            WorkQueue managerQueue = this.workQueueFactory.getWorkQueue(childJobStatus);
            this.processCollect(workUnit.getJobContext(), managerQueue, childJobStatus);
            managerQueue.waitForAllWorkers();
            this.postProcessor.process(workUnit.getJobContext(), childJobStatus);
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(workUnit.getJobContext(), throwable, childJobStatus);
        }
        finally {
            if (finish_flag) {
                this.finishWork(jobStatus, childJobStatus);
            }
            this.writeEndLog(childJobStatus);
        }
    }

    protected void finishWork(JobStatus parentJobStatus, JobStatus jobStatus) {
        if (jobStatus.isExecuting()) {
            jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        } else if (jobStatus.isShutdownGraceful() || jobStatus.isShutdownImmediate()) {
            jobStatus.suspend();
            parentJobStatus.setJobState(jobStatus.getJobState());
        } else {
            parentJobStatus.setJobState(jobStatus.getJobState());
        }
    }

    public void setWorkQueueFactory(WorkQueueFactory workQueueFactory) {
        this.workQueueFactory = workQueueFactory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    private void writeStartLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [partitionKey=");
            logStr.append(jobStatus.getPartitionKey());
            logStr.append("] [JobManagerName=");
            logStr.append(this.name);
            logStr.append("] [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }

    private void writeEndLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [partitionKey=");
            logStr.append(jobStatus.getPartitionKey());
            logStr.append("] [JobManagerName=");
            logStr.append(this.name);
            logStr.append("] [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }
}

