/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.listener;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.terasoluna.fw.batch.commonj.init.JobExecutor;
import jp.terasoluna.fw.batch.commonj.listener.WorkMapListener;
import jp.terasoluna.fw.batch.commonj.transaction.JobResultInfoHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.jobmessage.JobMessageInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobExecutorListener
implements WorkMapListener {
    private static final Log log = LogFactory.getLog(JobExecutorListener.class);
    private static final String REJECTED_JOB_EXIT_CODE = "-1";
    private Map<WorkItem, Work> map = Collections.synchronizedMap(new HashMap());
    private JobResultInfoHandler jobResultInfoHandler = null;

    public void addWork(WorkItem workItem, Work work) {
        this.map.put(workItem, work);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Map add work: " + workItem));
        }
    }

    public Object getWork(WorkItem workItem) {
        return this.map.get(workItem);
    }

    public Object removeWork(WorkItem workItem) {
        return this.map.remove(workItem);
    }

    public void workAccepted(WorkEvent we) {
        this.printSimpleLog("Work accepted: ", this.getWork(we.getWorkItem()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workCompleted(WorkEvent we) {
        JobExecutor jobExecutor = (JobExecutor)this.removeWork(we.getWorkItem());
        JobStatus jobStatus = jobExecutor.getJobStatus();
        JobMessageInfo jobMessageInfo = this.createJobMessageInfo(jobStatus, jobExecutor);
        this.printLog("Work completed: ", jobMessageInfo, jobStatus);
        try {
            this.jobResultInfoHandler.handle(jobMessageInfo);
        }
        catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! JobID: ");
            logStr.append(jobStatus.getJobId());
            logStr.append(" ");
            logStr.append(throwable.getMessage());
            log.error((Object)logStr.toString(), throwable);
        }
        finally {
            jobExecutor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workRejected(WorkEvent we) {
        JobExecutor jobExecutor = (JobExecutor)this.removeWork(we.getWorkItem());
        JobStatus jobStatus = null;
        JobMessageInfo jobMessageInfo = null;
        if (jobExecutor != null) {
            jobStatus = jobExecutor.getJobStatus();
            jobMessageInfo = this.createJobMessageInfo(jobStatus, jobExecutor);
            jobMessageInfo.setJobExitCode(REJECTED_JOB_EXIT_CODE);
            this.printLog("Work rejected: ", jobMessageInfo, jobStatus);
            try {
                this.jobResultInfoHandler.handle(jobMessageInfo);
            }
            catch (Throwable throwable) {
                StringBuilder logStr = new StringBuilder();
                logStr.append("Critical Error!! JobID: ");
                logStr.append(jobStatus.getJobId());
                logStr.append(" ");
                logStr.append(throwable.getMessage());
                log.error((Object)logStr.toString(), throwable);
            }
            finally {
                jobExecutor.destroy();
            }
        }
    }

    public void workStarted(WorkEvent we) {
        this.printSimpleLog("Work started: ", this.getWork(we.getWorkItem()));
    }

    public void setJobResultInfoHandler(JobResultInfoHandler jobResultInfoHandler) {
        this.jobResultInfoHandler = jobResultInfoHandler;
    }

    private JobMessageInfo createJobMessageInfo(JobStatus jobStatus, JobExecutor jobExecutor) {
        JobMessageInfo jobMessageInfo = new JobMessageInfo();
        jobMessageInfo.setJobRequestNo(jobStatus.getJobRequestNo());
        jobMessageInfo.setJobId(jobStatus.getJobId());
        jobMessageInfo.setJobExitCode(String.valueOf(jobStatus.getJobExitCode()));
        jobMessageInfo.setJobState(String.valueOf(jobStatus.getJobState().ordinal()));
        jobMessageInfo.setPartitionNo(jobStatus.getPartitionNo());
        jobMessageInfo.setPartitionKey(jobStatus.getPartitionKey());
        jobMessageInfo.setJobDiscriptorPath(jobExecutor.getJobInfo().getJobDiscriptorPath());
        return jobMessageInfo;
    }

    private void printLog(String message, JobMessageInfo jobMessageInfo, JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append("[AsyncJob] [JobRequestNo = ");
            builder.append(jobStatus.getJobRequestNo());
            builder.append("] [JobId = ");
            builder.append(jobStatus.getJobId());
            builder.append("] [PartitionNo = ");
            builder.append(jobMessageInfo.getPartitionNo());
            builder.append("] [ExitCode = ");
            builder.append(jobMessageInfo.getJobExitCode());
            builder.append("] [JobState = ");
            builder.append(jobMessageInfo.getJobState());
            builder.append("]");
            log.debug((Object)builder.toString());
        }
    }

    private void printSimpleLog(String message, Object object) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append("[AsyncJob] ");
            builder.append(object);
            builder.append("]");
            log.debug((Object)builder.toString());
        }
    }
}

