/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.fw.validation.ValidationUtil;

/**
 * {@link jp.terasoluna.fw.validation.ValidationUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ؃WbÑ[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.ValidationUtil
 */
public class ValidationUtilTest06 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ValidationUtilTest06.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ValidationUtilTest06(String name) {
        super(name);
    }

    /**
     * testToDate01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) Date:null<br>
     *
     * <br>
     * valuenull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate01() throws Exception {
        // O
        String value = null;
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        assertNull(result);
    }

    /**
     * testToDate02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) Date:null<br>
     *
     * <br>
     * value󔒂̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate02() throws Exception {
        // O
        String value = "";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        assertNull(result);
    }

    /**
     * testToDate03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"datePattern or datePatternStrict must be specified."<br>
     *
     * <br>
     * datePatternAdatePatternStrictnull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate03() throws Exception {
        // O
        String value = "2005/11/1";
        String datePattern = null;
        String datePatternStrict = null;

        // eXg{
        try {
            ValidationUtil.toDate(value, datePattern, datePatternStrict);
            fail("OȂB");
        } catch (Exception e) {
            //
            assertEquals("datePattern or datePatternStrict must be specified.",
                    e.getMessage());
        }
    }

    /**
     * testToDate04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:""<br>
     *         () datePatternStrict:""<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"datePattern or datePatternStrict must be specified."<br>
     *
     * <br>
     * datePatternAdatePatternStrict󔒂̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate04() throws Exception {
        // O
        String value = "2005/11/1";
        String datePattern = "";
        String datePatternStrict = "";

        // eXg{
        try {
            ValidationUtil.toDate(value, datePattern, datePatternStrict);
            fail("OȂB");
        } catch (Exception e) {
            //
            assertEquals("datePattern or datePatternStrict must be specified.",
                    e.getMessage());
        }
    }

    /**
     * testToDate05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:"yyyy.MM.dd"<br>
     *
     * <br>
     * ҒlF(߂l) Date:"2005/11/1"Date^<br>
     *
     * <br>
     * datePattern,datePatternStrictNotNullŐDateɕϊłꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate05() throws Exception {
        // O
        String value = "2005/11/1";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = "yyyy.MM.dd";

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        SimpleDateFormat format = new SimpleDateFormat(datePattern);
        Date hope = format.parse(value);
        assertEquals(hope, result);
        assertEquals("2005/11/01", format.format(result));
    }

    /**
     * testToDate06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) Date:null<br>
     *
     * <br>
     * datePatternStrictNotNullDateɕϊłAnullƂȂꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate06() throws Exception {
        // O
        String value = "2005/11/1";
        String datePattern = null;
        String datePatternStrict = "yyyy/MM/dd";

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        assertNull(result);
    }

    /**
     * testToDate07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"2005/11/24"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) Date:"2005/11/24"Date^<br>
     *
     * <br>
     * datePatternNotNullŐDateɕϊłꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate07() throws Exception {
        // O
        String value = "2005/11/24";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        SimpleDateFormat format = new SimpleDateFormat(datePattern);
        Date hope = format.parse(value);
        assertEquals(hope, result);
        assertEquals(value, format.format(result));
    }

    /**
     * testToDate08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"2005/11/24"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) Date:"2005/11/24"Date^<br>
     *
     * <br>
     * datePatternStrictNotNullŐDateɕϊłꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate08() throws Exception {
        // O
        String value = "2005/11/24";
        String datePattern = null;
        String datePatternStrict = "yyyy/MM/dd";

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        SimpleDateFormat format = new SimpleDateFormat(datePatternStrict);
        Date hope = format.parse(value);
        assertEquals(hope, result);
        assertEquals(value, format.format(result));
    }

    /**
     * testToDate09()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/24"<br>
     *         () datePattern:"asdf"<br>
     *
     * <br>
     * ҒlF(ԕω) O:OFIllegalArgumentException<br>
     *                    bZ[WFIllegal pattern character 'f'<br>
     *
     * <br>
     * datePatternɖȕ񂪂ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate09() throws Exception {
        // O
        String value = "2005/11/24";
        String datePattern = "asdf";
        String datePatternStrict = null;

        // eXg{
        try {
            ValidationUtil.toDate(value, datePattern, datePatternStrict);
            fail("OȂB");
        } catch (IllegalArgumentException e) {
            assertEquals("Illegal pattern character 'f'", e.getMessage());
        }
    }

    /**
     * testToDate10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/24"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"asdf"<br>
     *
     * <br>
     * ҒlF(ԕω) O:OFIllegalArgumentException<br>
     *                    bZ[WFIllegal pattern character 'f'<br>
     *
     * <br>
     * datePatternStrictɖȕ񂪂ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate10() throws Exception {
        // O
        String value = "2005/11/24";
        String datePattern = null;
        String datePatternStrict = "asdf";

        // eXg{
        try {
            ValidationUtil.toDate(value, datePattern, datePatternStrict);
            fail("OȂB");
        } catch (IllegalArgumentException e) {
            assertEquals("Illegal pattern character 'f'", e.getMessage());
        }
    }

    /**
     * testToDate11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"2005/2/29"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) Date:null<br>
     *
     * <br>
     * ͒l݂Ȃt̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate11() throws Exception {
        // O
        String value = "2005/2/29";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        assertNull(result);
    }

    /**
     * testToDate12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"2005/02/29"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) Date:null<br>
     *
     * <br>
     * ͒l݂Ȃt̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate12() throws Exception {
        // O
        String value = "2005/02/29";
        String datePattern = null;
        String datePatternStrict = "yyyy/MM/dd";

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        assertNull(result);
    }

    /**
     * testToDate13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"test"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) Date:null<br>
     *
     * <br>
     * ͒ltɕϊłȂꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToDate13() throws Exception {
        // O
        String value = "test";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        Date result = ValidationUtil.toDate(
                value, datePattern, datePatternStrict);

        // 
        assertNull(result);
    }

}
