/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.javascript.taglib;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;
import org.springframework.web.servlet.tags.RequestContextAwareTag;
import org.springmodules.validation.valang.javascript.ValangJavaScriptTranslator;
import org.springmodules.validation.valang.parser.ParseException;
import org.springmodules.validation.valang.parser.ValangParser;

public class ValangValidateTag
extends RequestContextAwareTag
implements BodyTag {
    public static final String VALANG_RULES_KEY_PREFIX = "ValangRules.";
    private final ValangJavaScriptTranslator translator = new ValangJavaScriptTranslator();
    private String commandName;
    private BodyContent bodyContent;

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    protected int doStartTagInternal() {
        return 2;
    }

    public void doInitBody() {
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            ArrayList rules = new ArrayList();
            if (this.commandName != null) {
                rules.addAll(this.getRulesForCommand());
            }
            if (this.bodyContent != null) {
                rules.addAll(this.parseRulesFromBodyContent());
            }
            if (rules.size() == 0) {
                throw new JspException("no valang validation rules were found");
            }
            JspWriter out = this.pageContext.getOut();
            out.write("<script type=\"text/javascript\" id=\"");
            out.write(this.commandName + "ValangValidator");
            out.write("\">");
            this.translator.writeJavaScriptValangValidator((Writer)out, this.commandName, true, rules, new MessageSourceAccessor((MessageSource)this.getRequestContext().getWebApplicationContext(), this.getRequestContext().getLocale()));
            out.write("</script>");
            return 6;
        }
        catch (IOException e) {
            throw new JspException("Could not write validation rules", (Throwable)e);
        }
    }

    protected Collection parseRulesFromBodyContent() throws JspException {
        try {
            return new ValangParser(this.bodyContent.getReader()).parseValidation();
        }
        catch (ParseException e) {
            throw new JspException("Could not parse valang", (Throwable)e);
        }
    }

    protected Collection getRulesForCommand() {
        Collection rules = (Collection)this.pageContext.findAttribute(VALANG_RULES_KEY_PREFIX + this.commandName);
        Assert.notNull((Object)rules, (String)("No valang rules for command '" + this.commandName + "' were found in the page context."));
        return rules;
    }

    public void doFinally() {
        super.doFinally();
        this.commandName = null;
    }
}

