/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * l̂߂̃Jp[T[NXB
 * 
 * <p>
 * w肳ꂽp[XABigDecimal^ɕϊB
 * ϊʂt@CsIuWFNgBigDecimal^̑ɒli[B
 * </p>
 * 
 */
public class DecimalColumnParser implements ColumnParser {

    /**
     * ltH[}bgɑΉ<code>DecimalFormat</code>ێ}bvB
     */
    private Map<String, DecimalFormatLocal> dfMap = 
            new ConcurrentHashMap<String, DecimalFormatLocal>();

    /**
     * w肳ꂽp[XABigDecimal^ɕϊBϊʂt@CsIuWFNgɊi[B
     * 
     * @param column J̕
     * @param t t@CsIuWFNg
     * @param method J̕t@CsIuWFNgɊi[郁\bh
     * @param columnFormat p[Xۂ̃tH[}bg
     * @throws IllegalArgumentException tH[}bg񂪃tH[}bgƂĕsłƂ
     * @throws IllegalAccessException t@CsIuWFNgւ̐ݒ肪sƂ
     * @throws InvocationTargetException t@CsIuWFNg̃\bhOX[Ƃ
     * @throws ParseException p[XsƂ
     */
    public void parse(String column, Object t, Method method,
            String columnFormat) throws IllegalArgumentException,
            IllegalAccessException, InvocationTargetException, ParseException {

        // l̃p[X
        if (columnFormat != null && !"".equals(columnFormat)) {
            DecimalFormatLocal dfLocal = dfMap.get(columnFormat);
            if (dfLocal == null) {
                dfLocal = new DecimalFormatLocal(columnFormat);
                dfMap.put(columnFormat, dfLocal);
            }
            DecimalFormat decimalFormat = dfLocal.get();
            decimalFormat.setParseBigDecimal(true);
            method.invoke(t, decimalFormat.parse(column));
        } else {
            method.invoke(t, new BigDecimal(column));
        }
    }
}
