/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.validation;

import jp.terasoluna.fw.batch.messages.MessageAccessor;
import jp.terasoluna.fw.batch.validation.ValidateException;
import jp.terasoluna.fw.batch.validation.ValidationResultHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;

public class StandardValidationResultHandler
implements ValidationResultHandler {
    private static final Log log = LogFactory.getLog(StandardValidationResultHandler.class);
    private boolean errorContinueFlg = false;
    private MessageAccessor messageAccessor = null;

    public boolean handle(BindException bindException, Object value) {
        if (bindException.getErrorCount() > 0) {
            if (this.errorContinueFlg) {
                StringBuilder errorString = new StringBuilder();
                for (Object objectErrors : bindException.getAllErrors()) {
                    FieldError fieldError = (FieldError)objectErrors;
                    String errorMessage = this.messageAccessor.getMessage(fieldError.getCode(), fieldError.getArguments());
                    String defaultMessage = fieldError.getDefaultMessage();
                    if (errorMessage == null) {
                        errorMessage = defaultMessage == null ? fieldError.getCode() : defaultMessage;
                    } else if (errorMessage.equals(fieldError.getCode()) && defaultMessage != null) {
                        errorMessage = defaultMessage;
                    }
                    errorString.append(errorMessage);
                }
                StringBuilder logStr = new StringBuilder();
                logStr.append(errorString.toString());
                logStr.append(" : [collectedData=");
                logStr.append(value);
                logStr.append("]");
                log.warn((Object)logStr.toString());
                return false;
            }
            throw new ValidateException(bindException);
        }
        return true;
    }

    public void setErrorContinueFlg(boolean errorContinueFlg) {
        this.errorContinueFlg = errorContinueFlg;
    }

    public void setMessageAccessor(MessageAccessor messageAccessor) {
        this.messageAccessor = messageAccessor;
    }
}

