/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.util.ReflectionUtils;

public abstract class RmiClientInterceptorUtils {
    private static final String ORACLE_CONNECTION_EXCEPTION = "com.evermind.server.rmi.RMIConnectionException";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$remoting$rmi$RmiClientInterceptorUtils == null ? (class$org$springframework$remoting$rmi$RmiClientInterceptorUtils = RmiClientInterceptorUtils.class$("org.springframework.remoting.rmi.RmiClientInterceptorUtils")) : class$org$springframework$remoting$rmi$RmiClientInterceptorUtils));
    static /* synthetic */ Class class$org$springframework$remoting$rmi$RmiClientInterceptorUtils;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public static Object invoke(MethodInvocation invocation, Remote stub, String serviceName) throws Throwable {
        try {
            return RmiClientInterceptorUtils.doInvoke(invocation, stub);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof RemoteException) {
                RemoteException rex = (RemoteException)targetEx;
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, serviceName);
            }
            throw targetEx;
        }
    }

    public static Object doInvoke(MethodInvocation invocation, Remote stub) throws InvocationTargetException {
        Method method = invocation.getMethod();
        try {
            if (method.getDeclaringClass().isInstance(stub)) {
                return method.invoke((Object)stub, invocation.getArguments());
            }
            Method stubMethod = stub.getClass().getMethod(method.getName(), method.getParameterTypes());
            return stubMethod.invoke((Object)stub, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            throw ex;
        }
        catch (NoSuchMethodException ex) {
            throw new RemoteProxyFailureException("No matching RMI stub method found for: " + method, ex);
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Invocation of RMI stub method failed: " + method, ex);
        }
    }

    public static Exception convertRmiAccessException(Method method, Throwable ex, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)message, ex);
        }
        if (Arrays.asList(method.getExceptionTypes()).contains(class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = RmiClientInterceptorUtils.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException)) {
            return new RemoteException(message, ex);
        }
        return new RemoteAccessException(message, ex);
    }

    public static Exception convertRmiAccessException(Method method, RemoteException ex, String serviceName) {
        return RmiClientInterceptorUtils.convertRmiAccessException(method, ex, RmiClientInterceptorUtils.isConnectFailure(ex), serviceName);
    }

    public static Exception convertRmiAccessException(Method method, RemoteException ex, boolean isConnectFailure, String serviceName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Remote service [" + serviceName + "] threw exception"), (Throwable)ex);
        }
        if (ReflectionUtils.declaresException(method, ex.getClass())) {
            return ex;
        }
        if (isConnectFailure) {
            return new RemoteConnectFailureException("Could not connect to remote service [" + serviceName + "]", ex);
        }
        return new RemoteAccessException("Could not access remote service [" + serviceName + "]", ex);
    }

    public static boolean isConnectFailure(RemoteException ex) {
        return ex instanceof ConnectException || ex instanceof ConnectIOException || ex instanceof UnknownHostException || ex instanceof NoSuchObjectException || ex instanceof StubNotFoundException || ex instanceof MarshalException || ex instanceof UnmarshalException || ORACLE_CONNECTION_EXCEPTION.equals(ex.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

