/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import javax.servlet.ServletRequest;
import org.apache.tiles.TilesException;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.preparer.ViewPreparer;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class AbstractSpringPreparerFactory
implements PreparerFactory {
    public ViewPreparer getPreparer(String name, TilesRequestContext context) throws TilesException {
        ServletRequest servletRequest = null;
        if (context.getRequest() instanceof ServletRequest) {
            servletRequest = (ServletRequest)context.getRequest();
        }
        ServletTilesApplicationContext tilesApplicationContext = null;
        if (context instanceof ServletTilesApplicationContext) {
            tilesApplicationContext = (ServletTilesApplicationContext)context;
        }
        if (servletRequest == null && tilesApplicationContext == null) {
            throw new IllegalStateException("SpringBeanPreparerFactory requires either a ServletRequest or a ServletTilesApplicationContext to operate on");
        }
        WebApplicationContext webApplicationContext = RequestContextUtils.getWebApplicationContext(servletRequest, tilesApplicationContext.getServletContext());
        return this.getPreparer(name, webApplicationContext);
    }

    protected abstract ViewPreparer getPreparer(String var1, WebApplicationContext var2) throws TilesException;
}

