/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Ǘ}l[WB
 * 
 * <p>
 * XbhPʂŊǗB
 * ʏAWebReił́A1̃NGXgɑ΂鏈1̃Xbhs߁A
 * NGXgXR[vĂяoꂽꍇAKɑ΂ďsƂoB
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.context.RequestContext
 * @see jp.terasoluna.fw.web.rich.context.support.AbstractRequestContextSupport
 *
 */
public class RequestContextManager {
    /**
     * OB
     */
    private static Log logger
        = LogFactory.getLog(RequestContextManager.class);

    /**
     * XbhPʂŃReLXgǗThreadLocalB
     */
    private static ThreadLocal<RequestContext> resources
        = new ThreadLocal<RequestContext>();

    /**
     * sXbhɑΉ鐧擾B
     * 񂪐ݒȂꍇAOB
     * @return 
     */
    public static RequestContext getRequestContext() {
        RequestContext ctx = resources.get(); 
        if (ctx == null) {
            logger.error("No RequestContext bound to thread!");
            throw new IllegalStateException(
                    "No RequestContext  bound to thread ["
                        + Thread.currentThread().getName() + "]");
        }
        return ctx;
    }

    /**
     * sXbhɑΉ鐧񂪓o^Ă邩肷B
     * @return o^Ătrue
     */
    public static boolean hasRequestContext() {
        return (resources.get() != null);
    }

    /**
     * sXbhɑΉ鐧o^B
     * @param ctx B
     */
    public static void bindRequestContext(
            RequestContext ctx) {
        if (ctx == null) {
            logger.error("RequestContext cannot set null.");
            throw new IllegalArgumentException(
                    "RequestContext cannot set null.");
        }
        
        RequestContext alreadyBoundCtx = resources.get();
        
        // Xbhɐ񂪐ݒ肳ĂȂ΁A̐ݒ肷
        if (alreadyBoundCtx == null) {
            resources.set(ctx);
            if (logger.isDebugEnabled()) {
                logger.debug("Bound RequestContext ["
                        + ctx + "] to thread ["
                        + Thread.currentThread().getName() + "]");
            }
        } else {
            logger.error("Already RequestContext bound to thread!");
            throw new IllegalStateException("Already RequestContext ["
                    + alreadyBoundCtx + "]" + "   ["
                    + Thread.currentThread().getName() + "]");
        }
    }

    /**
     * sXbhɑΉ鐧폜B
     */
    public static void unbindRequestContext() {
        RequestContext ctx = resources.get();
        if (ctx == null) {
            logger.error("No RequestContext bound to thread!");
            throw new IllegalStateException(
                    "No RequestContext  bound to thread ["
                        + Thread.currentThread().getName() + "]");
        }
        
        resources.remove();

        if (logger.isDebugEnabled()) {
            logger.debug("Removed RequestContext [" + ctx
                + "] from thread ["
                + Thread.currentThread().getName() + "]");
        }
    }
}
