/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import java.util.ArrayList;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.support.AbstractControllerUrlHandlerMapping;

public class ControllerBeanNameHandlerMapping
extends AbstractControllerUrlHandlerMapping {
    private String urlPrefix = "";
    private String urlSuffix = "";

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix != null ? urlPrefix : "";
    }

    public void setUrlSuffix(String urlSuffix) {
        this.urlSuffix = urlSuffix != null ? urlSuffix : "";
    }

    protected String[] buildUrlsForHandler(String beanName, Class beanClass) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.generatePathMapping(beanName));
        String[] aliases = this.getApplicationContext().getAliases(beanName);
        for (int i = 0; i < aliases.length; ++i) {
            urls.add(this.generatePathMapping(aliases[i]));
        }
        return StringUtils.toStringArray(urls);
    }

    protected String generatePathMapping(String beanName) {
        String name = beanName.startsWith("/") ? beanName : "/" + beanName;
        StringBuffer path = new StringBuffer();
        if (!name.startsWith(this.urlPrefix)) {
            path.append(this.urlPrefix);
        }
        path.append(name);
        if (!name.endsWith(this.urlSuffix)) {
            path.append(this.urlSuffix);
        }
        return path.toString();
    }
}

