/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.formcheck.controller;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.formcheck.bean.FormCheckResultData;
import jp.terasoluna.rich.functionsample.formcheck.bean.QueryFormCheckInputData;
import jp.terasoluna.rich.functionsample.formcheck.service.QueryFormCheckService;

/**
 * NG``FbÑRg[<br>
 * ``FbNƊ֌WȂȂ̂ŉ̏sȂB
 *
 */
public class QueryFormCheckController extends
        TerasolunaController<QueryFormCheckInputData, FormCheckResultData> {
    
    /**
     * T[rXNX
     */
    protected QueryFormCheckService queryFormCheckService = null;
    
    /**
     * oChȌƂsB<br>
     * java.util.Date^̃NG``FbNݒsB<br>
     * ttH[}bg<code>yyyy/MM/dd</code>ɐݒ肳ĂB
     * 
     * @param request HTTPNGXg
     * @param binder VoChCX^X
     * @throws Exception Oꍇ
     */
    @Override
    protected void initBinder(HttpServletRequest request,
            ServletRequestDataBinder binder) throws Exception {
        DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        binder.registerCustomEditor(Date.class, "dateClass",
                new CustomDateEditor(dateFormat, false));
    }

    /**
     * T[rXNXsB<br>
     * T[rXNX͌``FbNƊ֌WȂȂ̂ŉ̏sȂB
     *
     * @param command ̓f[^
     * @return ʃf[^
     * @throws Exception O
     */
    @Override
    protected FormCheckResultData executeService(
            QueryFormCheckInputData command) throws Exception {
        return queryFormCheckService.succeed(command);
    }

    /**
     * T[rXNXݒ肷B
     * @param queryFormCheckService T[rXNX
     */
    public void setQueryFormCheckService(QueryFormCheckService
            queryFormCheckService) {
        this.queryFormCheckService = queryFormCheckService;
    }
}
