/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.dbmessage.service;

import java.util.Locale;
import org.springframework.context.NoSuchMessageException;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.service.rich.exception.ServiceException;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import jp.terasoluna.rich.functionsample.common.context.support.RequestContextSupportImpl;
import jp.terasoluna.rich.functionsample.common.messages.DBMessageAccessor;
import jp.terasoluna.rich.functionsample.common.messages.ReloadDataSourceMessage;
import jp.terasoluna.rich.functionsample.dbmessage.bean.DBMessageInputData;
import jp.terasoluna.rich.functionsample.dbmessage.bean.DBMessageResultData;
import jp.terasoluna.rich.functionsample.dbmessage.bean.MessageVO;

/**
 * DBbZ[W擾T[rNX
 *
 */
public class DBMessageServiceImpl implements DBMessageService {
    
    /**
     * NX
     */
    protected RequestContextSupport ctxSupport = null;
    
    /**
     * DBbZ[WǗ̃bZ[W擾NX
     */
    protected DBMessageAccessor msgAcc = null;
    
    /**
     * DBbZ[WǗ̃bZ[WĒ`NX
     */
    protected ReloadDataSourceMessage reloader = null;

    /**
     * 擾pDAONXB
     * SpringɂCX^Xݒ肳B
     */
    protected QueryDAO queryDAO = null;
    
    /**
     * XVpDAONXB
     * SpringɂCX^Xݒ肳B
     */
    protected UpdateDAO updateDAO = null;

    /**
     * bZ[W擾B<br>
     * 1. NX猾AA擾B<br>
     * 2. AAɂ郍P[ݒ肷B<br>
     * 3. ͕messagȅꍇɃbZ[W擾B<br>
     * 4. ͕reload̏ꍇɃbZ[WĒ`ăbZ[W擾B<br>
     * 5. ͕messagereload̈ȊO͗OX[B
     *
     * @param params ̓NX
     * @return ʃNX
     * @throws Exception O
     */
    public DBMessageResultData getMessage(DBMessageInputData params) 
                                                    throws Exception {
        
        DBMessageResultData result = new DBMessageResultData();
        
        //P[𐧌NX擾
        String language = (String) ctxSupport.getProperty(
                RequestContextSupportImpl.LANGUAGE_KEY);
        String country =
            (String) ctxSupport.getProperty(RequestContextSupportImpl.COUNTRY_KEY);
        String variant =
            (String) ctxSupport.getProperty(RequestContextSupportImpl.VARIANT_KEY);
        
        //P[NX
        Locale locale = new Locale(language, country, variant);
        
        // ނmessagȅꍇAbZ[W擾B
        // reload̏ꍇAbZ[WĒ`ăbZ[W擾B
        // ̑̏ꍇAOB
        if (params.getContent().equals("message")) {
            try {
            result.setMessage(
                    msgAcc.getMessage(params.getMessageKey(), locale));
            } catch (NoSuchMessageException e) {
                //͂ꂽbZ[WL[ɑ΂ē͂ꂽP[
                //ftHgP[ŃbZ[W݂ȂꍇAG[ԂB
                throw new ServiceException("errors.UC110.00001");
            }
        } else if (params.getContent().equals("reload")) {
            
            //݂̃P[ɓ郁bZ[WNX𐶐B
            MessageVO replaceMessageVO = new MessageVO();
            replaceMessageVO.setCode(params.getMessageKey());
            replaceMessageVO.setLanguages(language);
            replaceMessageVO.setContry(country);
            replaceMessageVO.setVariant(variant);
            
            //DB猻ݐݒ肳Ă郁bZ[W擾
            MessageVO messageVO = queryDAO.executeForObject(
                    "getMessage", replaceMessageVO, MessageVO.class);
            
            //DBɑ݂ȂbZ[W̏ꍇ̓G[ԂB
            if (messageVO == null) {
                throw new ServiceException("errors.UC110.00001");
            }
            
            //VbZ[Wݒ肷B
            replaceMessageVO.setMessage("ύXꂽbZ[WłB");
            replaceMessageVO.setId(messageVO.getId());
            
            //VbZ[WDBɔf
            updateDAO.execute("updateMessage", replaceMessageVO);
            
            //[hsB
            reloader.reloadDataSource();
            
            //[hꂽbZ[W\[X烁bZ[W擾
            result.setMessage(
                    msgAcc.getMessage(params.getMessageKey(), locale));
            
            //DB̃bZ[Wɖ߂B
            updateDAO.execute("updateMessage", messageVO);
            reloader.reloadDataSource();
        } else {
            //ނmessageAreloadȊȌꍇ̓G[ԂB
            throw new ServiceException("errors.UC110.00002");
        }
        return result;
    }

    /**
     * NXݒ肷B
     * @param ctxSupport NX
     */
    public void setCtxSupport(RequestContextSupport ctxSupport) {
        this.ctxSupport = ctxSupport;
    }
    
    /**
     * DBbZ[WǗ̃bZ[W擾NXݒ肷B
     * @param msgAcc DBbZ[WǗ̃bZ[W擾NX
     */
    public void setMsgAcc(DBMessageAccessor msgAcc) {
        this.msgAcc = msgAcc;
    }

    /**
     * DBbZ[WǗ̃bZ[WĒ`NXݒ肷B
     * @param reloader DBbZ[WǗ̃bZ[WĒ`NX
     */
    public void setReloader(ReloadDataSourceMessage reloader) {
        this.reloader = reloader;
    }
    
    /**
     * queryDAOݒ肷B
     * @param queryDAO queryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * updateDAOݒ肷B
     * @param updateDAO updateDAOB
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
}
