/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.thin.BLogicResult} NX
 * ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNo͏NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.thin.BLogicResult
 */
public class BLogicResultTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicResultTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public BLogicResultTest(String name) {
        super(name);
    }

    /**
     * testGetResultObject01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () resultObject:"resultObject"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:"resultObject"<br>
     *         
     * <br>
     * BLogicResultɊi[ĂresultObject𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultObject01() throws Exception {
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        String str = "resultObject";

        // resultObjectݒ
        UTUtil.setPrivateField(blogicResult, "resultObject", str);

        // eXg{E
        assertEquals("resultObject", blogicResult.getResultObject());
    }

    /**
     * testSetResultObject01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() resultObject:"resultObject"<br>
     *         () resultObject:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) resultObject:"resultObject"<br>
     *         
     * <br>
     * Ɏw肵lBLogicResultresultObjectɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetResultObject01() throws Exception {
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        String str = "resultObject";

        // eXg{
        blogicResult.setResultObject(str);

        // 
        assertEquals("resultObject", UTUtil.getPrivateField(blogicResult,
                "resultObject"));
    }

    /**
     * testGetResultString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () resultString:"resultString"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"resultString"<br>
     *         
     * <br>
     * BLogicResultɊi[ĂresultString𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultString01() throws Exception {
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        String str = "resultString";

        // resultStringݒ
        UTUtil.setPrivateField(blogicResult, "resultString", str);

        // eXg{E
        assertEquals("resultString", blogicResult.getResultString());
    }

    /**
     * testSetResultString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() resultString:"resultString"<br>
     *         () resultString:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) resultString:"resultString"<br>
     *         
     * <br>
     * Ɏw肵lBLogicResultresultStringɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetResultString01() throws Exception {
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        String str = "resultString";

        // eXg{
        blogicResult.setResultString(str);

        // 
        assertEquals("resultString", UTUtil.getPrivateField(blogicResult,
                "resultString"));

    }

    /**
     * testGetErrors01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () errors:("property",BLogicMessage("key","value"))<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicMessages:("property",BLogicMessage("key","value"))<br>
     *         
     * <br>
     * BLogicResultɊi[Ăerrors𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetErrors01() throws Exception {
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        // BLogicMessage
        BLogicMessage error = new BLogicMessage("key", "value");
        
        // BLogicMessages
        BLogicMessages errors = new BLogicMessages();
        errors.add("property", error);
        
        // messagesݒ
        UTUtil.setPrivateField(blogicResult, "errors", errors);

        // eXg{E
        assertSame(errors, blogicResult.getErrors());
    }

    /**
     * testSetErrors01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() paramErrors:("property",BLogicMessage("key","value"))<br>
     *         () paramErrors:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) errors:("property",BLogicMessage("key","value"))<br>
     *         
     * <br>
     * Ɏw肵lBLogicResulterrorsɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetErrors01() throws Exception {
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        // BLogicMessage
        BLogicMessage error = new BLogicMessage("key", "value");
        
        // BLogicMessages
        BLogicMessages errors = new BLogicMessages();
        errors.add("property", error);

        // eXg{
        blogicResult.setErrors(errors);

        // 
        assertSame(errors, UTUtil.getPrivateField(blogicResult, "errors"));

    }

    /**
     * testGetMessages01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () messages:("property",BLogicMessage("key","value"))<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicMessages:("property",BLogicMessage("key","value"))<br>
     *         
     * <br>
     * BLogicResultɊi[Ămessages𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessages01() throws Exception {
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        // BLogicMessage
        BLogicMessage message = new BLogicMessage("key", "value");
        
        // BLogicMessages
        BLogicMessages messages = new BLogicMessages();
        messages.add("property", message);

        // messagesݒ
        UTUtil.setPrivateField(blogicResult, "messages", messages);

        // eXg{E
        assertSame(messages, blogicResult.getMessages());
    }

    /**
     * testSetMessages01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() paramMessages:("property",BLogicMessage("key","value"))<br>
     *         () paramMessages:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) messages:("property",BLogicMessage("key","value"))<br>
     *         
     * <br>
     * Ɏw肵lBLogicResultmessagesɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetMessages01() throws Exception {
        // O
        // BLogico͏
        BLogicResult blogicResult = new BLogicResult();

        // eXglݒ
        // BLogicMessage
        BLogicMessage message = new BLogicMessage("key", "value");
        
        // BLogicMessages
        BLogicMessages messages = new BLogicMessages();
        messages.add("property", message);

        // eXg{
        blogicResult.setMessages(messages);

        // 
        assertSame(messages, UTUtil.getPrivateField(blogicResult, "messages"));
    }

}
