/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import jp.terasoluna.fw.exception.SystemException;

/**
 * oCgz_E[hf[^Ƃ邽߂̃NXB
 */
public class DownloadByteArray extends AbstractDownloadObject {

    /**
     * VAo[W<code>UID</code>B
     */
    private static final long serialVersionUID = 1L;

    /**
     * _E[heB
     */
    protected byte[] byteArray = null;

    /**
     *RXgN^B
     *
     * @param name _E[hB
     * @param byteArray _E[hełoCgzB
     */
    public DownloadByteArray(String name, byte[] byteArray) {
        super(name, null, null);
        if (byteArray == null) {
            throw new SystemException(new IllegalArgumentException(
                            "Download content must not be null"),
                NO_DOWNLOAD_CONTENT_ERROR);
        }
        this.byteArray = byteArray;
    }

    /**
     * _E[hTCY擾B
     *
     * @return _E[hTCYB
     */
    @Override
    public int getLengthOfData() {
        return byteArray.length;
    }

    /**
     * _E[hẽXg[IɎ擾B
     *
     * @return Xg[B
     */
    @Override
    public InputStream getStreamInternal() throws FileNotFoundException {
        return new ByteArrayInputStream(byteArray);
    }

}
