package jp.terasoluna.toursample.server.common.validation;

import org.springframework.validation.BindException;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

/**
 *
 * サーバ入力値検証処理のサンプル実装クラス
 *
 *
 */
public class SampleValidatorImpl implements SampleValidator {
    private Validator validator;

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public void validate(Object target) throws BindException {
        BindException errors = new BindException(target, target.getClass()
                .getSimpleName());
        ValidationUtils.invokeValidator(validator, target, errors);
        if (errors.getErrorCount() > 0) {
            throw errors;
        }
    }

}
