package jp.terasoluna.toursample.server.common.service;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebService;

import jp.terasoluna.toursample.server.common.bizlogic.CodeListBizLogic;
import jp.terasoluna.toursample.server.common.code.SelectableValue;
import jp.terasoluna.toursample.server.common.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.common.exception.handler.SampleSoapFaultExceptionHandler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * 通常のWebサービスのサンプル
 * SpringBeanAutowiringSupportを継承し作成する
 *
 */
@WebService(serviceName = "CodeListService", targetNamespace = "http://jp.terasoluna.toursample")
public class CodeListService extends SpringBeanAutowiringSupport {

    @Autowired
    private CodeListBizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;

    /**
     * 出発地のコードリストを取得する
     * @return
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "GetDeptPlaceList")
    public List<SelectableValue> getDeptPlaceList()
            throws SampleSoapFaultException {
        try {
            // ビジネスロジックの実施
            return bizLogic.findDeptPlaceList();
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
        return null;
    }

    /**
     * ツアー分類のコードリストを取得する
     * @return
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "GetTourCategoryList")
    public List<SelectableValue> getTourCategoryList()
            throws SampleSoapFaultException {
        try {
            // ビジネスロジックの実施
            return bizLogic.findTourCategoryList();
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
        return null;
    }

}
