package jp.terasoluna.toursample.server.common.bizlogic;

import java.util.List;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.toursample.server.common.code.SelectableValue;
import jp.terasoluna.toursample.server.common.exception.ApplicationException;

import org.springframework.beans.factory.annotation.Autowired;

public class CodeListBizLogicImpl implements CodeListBizLogic {

    // サンプルのデフォルトは、MockDAOになっているので、DB接続したい場合は、
    // h2dbフォルダ内にあるH2DBを動作させること
    // また、環境設定手順の詳細はプロジェクト直下のreadme_h2db.txtを参照のこと
    @Autowired
    private QueryDAO queryDAO;

    @Override
    public List<SelectableValue> findDeptPlaceList()
            throws ApplicationException {
        return queryDAO.executeForObjectList("COMMON.selectDeptPlaces", null);
    }

    @Override
    public List<SelectableValue> findTourCategoryList()
            throws ApplicationException {

        return queryDAO.executeForObjectList("COMMON.selectTourCategories", null);

    }

}
