package jp.terasoluna.toursample.server.b01.service;

import javax.jws.WebMethod;
import javax.jws.WebService;

import jp.terasoluna.toursample.server.b01.bizlogic.B01_01BizLogic;
import jp.terasoluna.toursample.server.b01.dto.B01_01_01_S01InputDto;
import jp.terasoluna.toursample.server.b01.dto.B01_01_01_S01OutputDto;
import jp.terasoluna.toursample.server.common.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.common.exception.handler.SampleSoapFaultExceptionHandler;
import jp.terasoluna.toursample.server.common.validation.SampleValidator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * 通常のWebサービスのサンプル
 * SpringBeanAutowiringSupportを継承し作成する
 *
 */
@WebService(serviceName="B01_01Service", targetNamespace = "http://jp.terasoluna.toursample")
public class B01_01Service extends SpringBeanAutowiringSupport {

    @Autowired
    private B01_01BizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier("defaultValidator")
    private SampleValidator defaultValidator;

    /**
     * ログインする
     * @param input
     * @return
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "ExecuteB01_01_01_S01")
    public B01_01_01_S01OutputDto executeB01_01_01_S01(B01_01_01_S01InputDto input)
            throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実施
            defaultValidator.validate(input);
            // ビジネスロジックの実施
            return bizLogic.executeB01_01_01_S01(input);
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
        return null;
    }


}
