package jp.terasoluna.toursample.server.a01.validation;

import java.util.Calendar;
import java.util.Date;

import jp.terasoluna.fw.validation.springmodules.BaseMultiFieldValidator;
import jp.terasoluna.toursample.server.a01.dto.A01_01_01_S01InputDto;

import org.springframework.validation.Errors;

/**
 * カスタム入力チェックのサンプル
 * BaseMultiFieldValidatorを継承し作成する
 *
 */
public class A01_01_01_C01CustomValidator extends BaseMultiFieldValidator {

    @Override
    protected void validateMultiField(Object obj, Errors errors) {
        A01_01_01_S01InputDto inputDto = (A01_01_01_S01InputDto) obj;
        customValidate01(errors, inputDto);
        customeValidate02(errors, inputDto);
    }

    private void customValidate01(Errors errors, A01_01_01_S01InputDto inputDto) {
        boolean deptDateInputed = inputDto.getTour().getDeptDate() != null;
        boolean tourDayInputed = inputDto.getTour().getTourDay() != null;

        if (deptDateInputed ^ tourDayInputed) {
            errors.reject("ERROR_A01_01_0001");
        }
    }

    private void customeValidate02(Errors errors, A01_01_01_S01InputDto inputDto) {
        Date deptDate = inputDto.getTour().getDeptDate();
        if (deptDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.set(Calendar.HOUR_OF_DAY, 24);
            cal.set(Calendar.MINUTE, 0);
            cal.set(Calendar.SECOND, 0);
            Date today = cal.getTime();

            if (deptDate.compareTo(today) < 0) {
                errors.reject("ERROR_A01_01_0002");
            }
        }
    }

}
