package jp.terasoluna.toursample.server.a01.service;

import javax.jws.WebMethod;
import javax.jws.WebService;

import jp.terasoluna.toursample.server.a01.bizlogic.A01_02BizLogic;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S01InputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S01OutputDto;
import jp.terasoluna.toursample.server.common.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.common.exception.handler.SampleSoapFaultExceptionHandler;
import jp.terasoluna.toursample.server.common.validation.SampleValidator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * 通常のWebサービスのサンプル
 * SpringBeanAutowiringSupportを継承し作成する
 *
 */
@WebService(serviceName = "A01_02Service", targetNamespace = "http://jp.terasoluna.toursample")
public class A01_02Service extends SpringBeanAutowiringSupport {

    @Autowired
    private A01_02BizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier("defaultValidator")
    private SampleValidator defaultValidator;


    /**
     * ツアー情報を検索する
     * @param input
     * @return
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "ExecuteA01_02_01_S01")
    public A01_02_01_S01OutputDto executeA01_02_01_S01(
            A01_02_01_S01InputDto input) throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実施
            defaultValidator.validate(input);
            // ビジネスロジックの実施
            return bizLogic.executeA01_02_01_S01(input);
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
        return null;
    }

}
