package jp.terasoluna.toursample.server.a01.bizlogic;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataHandler;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.toursample.server.a01.dto.A01_03_01_S02InputDto;
import jp.terasoluna.toursample.server.common.exception.ApplicationException;

public class A01_03BizLogicImpl implements A01_03BizLogic {
    // 一時保存フォルダ
    private static final String TEMP_DIR = "C:\\tmp\\";

    //ファイル保存するだけのダミー処理

    @Override
    public void executeA01_03_01_S01(DataHandler dataHandler)
            throws ApplicationException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = dataHandler.getInputStream();
            // ファイルの保存
            os = new BufferedOutputStream(new FileOutputStream(TEMP_DIR
                    + "uploadfileWithStream.dat"));

            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            } catch (IOException e) {
                throw new SystemException(e);
            }
        }
    };

    @Override
    public void executeA01_03_01_S02(A01_03_01_S02InputDto input)
            throws ApplicationException {
        OutputStream os = null;
        try {
            // ファイル名を取得しファイルデータを保存
            os = new BufferedOutputStream(new FileOutputStream(TEMP_DIR
                    + input.getFileName()));
            os.write(input.getFileData());
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    throw new SystemException(e);
                }
            }
        }
    }


}
