﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.ExceptionHandling;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.TourSample.Client.Common.CommonData;
using Terasoluna.TourSample.Client.B01_01ServiceReference;
using Terasoluna.TourSample.Client.Common.Code;


namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ログイン画面
    /// </summary>
    [ScreenId("SC_B01_01_01")]
    public partial class SC_B01_01_01View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_B01_01_01ViewData ViewData { get; set; }


        public SC_B01_01_01View()
        {
            InitializeComponent();
            ///画面データの生成
            ViewData = ValidatableViewDataManager.CreateViewData<SC_B01_01_01ViewData>();
        }

        private void SC_B01_01_01View_Load(object sender, EventArgs e)
        {
            ///バインド設定
            sC_B01_01_01ViewDataBindingSource.DataSource = ViewData;            
            ///画面の初期値設定
            ViewData.UserId = "terasoluna";
            ViewData.Password = "password";
        }

        /// <summary>
        /// ログインボタン押下
        /// </summary>
        private void loginButton_Click(object sender, EventArgs e)
        {
            ///イベント処理実行
            b01_01_01_C01EventProcessWorker.RunWorkerAsync();
        }
        
        /// <summary>
        /// 遷移先画面クローズ時
        /// </summary>
        private void formForwarderToSC_B01_01_02_ForwardFormClosed(object sender, ForwardFormClosedEventArgs e)
        {
            if (e.CloseState == FormState.Closed)
            {
                ///初期画面はFormFowarder管理外の画面のため、
                ///FormForwardManager.Reshowメソッドは使用せずForm.Showメソッドを実行
                Show();
            }
        }

        /// <summary>
        /// ログインボタン押下時のイベント処理完了時
        /// </summary>
        private void b01_01_01_C01EventProcessWorker_Completed(object sender, EventProcCompletedEventArgs e)
        {
            ///ログイン成功時
            if (e.Result.IsSuccess)
            {                
                ///アプリケーション全体の共通データ領域へ保存
                ApplicationCommonData.Instance.UserId = ViewData.UserId;
                B01_01_01_S01OutputDto outputDto = e.Result.BizLogicResult as B01_01_01_S01OutputDto;
                if (outputDto != null)
                {
                    ///Role（ユーザ権限情報）のセット
                    ApplicationCommonData.Instance.Role = (Terasoluna.TourSample.Client.Common.Code.RoleEnum)
                        Enum.Parse(typeof(Terasoluna.TourSample.Client.Common.Code.RoleEnum), outputDto.Role.ToString());
                }
                ///画面遷移                
                ///初期画面をCloseするとAP終了してしまうので非表示（Hide）する
                Hide();
                formForwarderToSC_B01_01_02.Forward();
            }
        }


    }
}
