﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Windows.ViewModel.Validation;
using System.ComponentModel;
using Terasoluna.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Terasoluna.TourSample.Client.Common.ViewData;

namespace Terasoluna.TourSample.Client.A01.ViewData
{
    /// <summary>
    /// ツアー検索画面の画面データ（ルート）
    /// </summary>
    [DefaultRuleset("RS01")]
    public class SC_A01_02_01ViewData : ValidatableRootViewData
    {
        [DisplayName("ツアー名称")]
        [RequiredValidator(Tag="ツアー名称", Ruleset="RS01")]
        ///TextBox.MaxLengthで制御するのでコメントアウト
        ///[StringLengthRangeValidator(Tag = "ツアー名称", Ruleset = "RS01",
        ///    UpperBound = 30, UpperBoundType = RangeBoundaryType.Inclusive)]
        public virtual string TourName { get; set; }

        /// ソート可能なリストデータの実装例
        /// DataGridViewでソート操作可能
        public virtual SortableNestedViewDataList<SC_A01_02_01Tour> TourList { get; set; }
    }
}
