﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Windows.ViewModel.Validation;
using System.ComponentModel;
using Terasoluna.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using System.Text.RegularExpressions;

namespace Terasoluna.TourSample.Client.A01.ViewData
{
    /// <summary>
    /// 担当者情報追加画面の画面データ（ルート）
    /// </summary>
    [DefaultRuleset("RS01")]
    public class SC_A01_01_02ViewData : ValidatableRootViewData
    {
        [DisplayName("担当者名")]
        [RequiredValidator(Tag="担当者名", Ruleset="RS01")]
        [ZenkakuStringValidator(Tag = "担当者名", Ruleset = "RS01")]
        ///TextBox.MaxLengthで制御するのでコメントアウト
        //[StringLengthRangeValidator(Tag="担当者名", Ruleset="RS01",
        //    UpperBound=20, UpperBoundType=RangeBoundaryType.Inclusive)]
        public virtual string ConductorName { get; set; }

        [DisplayName("メールアドレス")]
        [RequiredValidator(Tag = "メールアドレス", Ruleset = "RS01")]
        [RegexValidatorEx(@"\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*",
            RegexOptions.IgnoreCase, Tag = "メールアドレス", Ruleset = "RS01")]
        ///TextBox.MaxLengthで制御するのでコメントアウト
        //[StringLengthRangeValidator(Tag = "メールアドレス", Ruleset = "RS01",
        //    UpperBound = 20, UpperBoundType = RangeBoundaryType.Inclusive)]
        public virtual string Email { get; set; }
        
    }
}
