﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Microsoft.Practices.Unity;
using Terasoluna.ServiceModel;
using System.ServiceModel;
using Terasoluna.Threading;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.TourSample.Client.A01.Dto;
using Terasoluna.TourSample.Client.Common.IO;
using Terasoluna.TourSample.Client.A01_03MtomServiceReference;

namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// Mtomでファイルダウンロードするビジネスロジック
    /// </summary>
    public class A01_03_01_C02BizLogic
    {   
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "A01_03MtomServicePort";

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// ファイルをアップロードする
        /// </summary>
        /// <param name="inputDto"></param>
        public void Upload(A01_03_01_C02InputDto inputDto)
        {
            ///エンドポイントアドレスの取得
            ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
            EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
            A01_03MtomServiceClient client = new A01_03MtomServiceClient(EndpointName, address);
            ///通常のStream
            //using (FileStream fs = new FileStream(inputDto.UploadFilePath, FileMode.Open))
            ///ファイル送信率を通知するStream
            using (NotifyProgressInfoFileStream fs =
                new NotifyProgressInfoFileStream(new FileStream(inputDto.UploadFilePath, FileMode.Open)))
            {
                try
                {
                    byte[] uploadData = new byte[fs.Length];
                    fs.Read(uploadData, 0, (int)fs.Length);
                    A01_03_01_S02InputDto serverInputDto = new A01_03_01_S02InputDto()
                    {
                        FileData = uploadData,
                        FileName = Path.GetFileName(inputDto.UploadFilePath)
                    };
                    client.ExecuteA01_03_01_S02(serverInputDto);
                    client.Close();
                }
                catch (System.Exception)
                {
                    if (client != null)
                    {
                        client.Abort();
                    }
                    throw;
                }
            }
        }
    }
}
