﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Microsoft.Practices.Unity;
using Terasoluna.ServiceModel;
using System.ServiceModel;
using Terasoluna.Threading;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.TourSample.Client.A01.Dto;
using Terasoluna.TourSample.Client.Common.IO;
using Terasoluna.TourSample.Client.A01_03MtomServiceReference;

namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// Mtomストリーミング転送モードでファイルアップロードするビジネスロジック
    /// </summary>
    public class A01_03_01_C01BizLogic
    {   
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "A01_03MtomServicePort_Stream";

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// ファイルアップロードする
        /// </summary>
        public void Upload(A01_03_01_C01InputDto inputDto)
        {
            ///エンドポイントアドレスの取得
            ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
            EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
            A01_03MtomServiceClient client = new A01_03MtomServiceClient(EndpointName, address);
            ///通常のStream
            //using (FileStream fs = new FileStream(inputDto.UploadFilePath, FileMode.Open))
            ///ファイル送信率を通知するStream
            using (NotifyProgressInfoFileStream fs = 
                new NotifyProgressInfoFileStream(new FileStream(inputDto.UploadFilePath, FileMode.Open)))
            {
                try
                {
                    client.ExecuteA01_03_01_S01(fs);
                    client.Close();
                }
                catch (System.Exception)
                {
                    if (client != null)
                    {
                        client.Abort();
                    }
                    throw;
                }
            }
        }
    }
}
