﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Terasoluna.Windows.Forms.Threading;
using System.Windows.Forms;
using Terasoluna.Threading;
using Terasoluna.Unity;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using Terasoluna.TourSample.Client.A01.Dto;
using Microsoft.Practices.Unity;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.TourSample.Client.A01_02MtomServiceReference;


namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// Mtomストリーミング転送モードでファイルダウンロードするビジネスロジック
    /// </summary>
    public class A01_02_01_C02BizLogic
    {
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "A01_02MtomServicePort_Stream";

        /// <summary>
        /// ストリームを読み取るためのバッファサイズ
        /// </summary>
        private const int BUFFER_SIZE = 1024;

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// ファイルをダウンロードする
        /// </summary>
        /// <param name="inputDto"></param>
        /// <returns></returns>     
        public A01_02_01_C02OutputDto Download(A01_02_01_S02InputDto inputDto)
        {            
            A01_02MtomServiceClient client = null;
            string fileName = "";
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new A01_02MtomServiceClient(EndpointName, address);

                ///一時ファイルに保存してビジネスロジックを終了し、
                ///イベント完了時にSaveFileDialogを表示し指定した場所に一時ファイルの内容をコピーする
                using (Stream stream = client.ExecuteA01_02_01_S02(inputDto))
                {
                    
                    if (InvocationScope.Current.GetContext<EventProcessContext>().CancellationPending)
                    {
                        ///ユーザにキャンセルされた場合に、処理を中断する
                        return new A01_02_01_C02OutputDto();
                    }                    
                    ///一時ファイルへ書き込み
                    fileName = Path.GetTempFileName();
                    using (FileStream outputFile = File.Create(fileName))
                    {
                        byte[] buf = new byte[BUFFER_SIZE];
                        int len = 0;
                        while ((len = stream.Read(buf, 0, buf.Length)) != 0)
                        {
                            outputFile.Write(buf, 0, len);
                        }
                    }                    
                    if (InvocationScope.Current.GetContext<EventProcessContext>().CancellationPending)
                    {
                        ///ユーザにキャンセルされた場合に、一時ファイルを削除
                        File.Delete(fileName);
                        return new A01_02_01_C02OutputDto();
                    }
                }

                client.Close();
                return new A01_02_01_C02OutputDto(fileName);
            }
            catch (System.Exception)
            {
                if (client != null)
                {
                    client.Abort();
                }
                ///一時ファイルの削除
                if (!string.IsNullOrEmpty(fileName) && File.Exists(fileName))
                {
                    File.Delete(fileName);
                }
                throw;
            }          
        }

    }
}
