﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using Terasoluna.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using Terasoluna.Windows.Forms.Threading;
using Terasoluna.Threading;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.ExceptionHandling;
using System.Threading;
using System.IO;

namespace Terasoluna.TourSample.Client.Common.VirusCheck
{
    ///ウィルスチェック処理のモッククラス
    ///UICallHandler属性を有効にするためにSetInterceptor属性を付与   
    [SetDefaultInterceptor(typeof(VirtualMethodInterceptor))]
    public class MockVirusChecker : IVirusChecker
    {
        protected const string RUNNING = "処理中";
        protected const string CANCELLED = "中断";
        protected const string SUCCESS = "正常終了";
        protected const string VIRUS_DETECTED = "ウィルスあり";
        protected const string SYSTEM_ERROR = "異常終了";

        /// 成功か失敗かのダミーの動きを設定可能にする
        public bool IsSuccess { get; set; }

        /// キャンセルしたか
        protected bool Cancelled
        {
            get
            {
                return InvocationScope.Current.GetContext<EventProcessContext>().CancellationPending;
            }
        }

        ///例外的にビジネスロジック内でUI処理する例
        public VirusCheckResult CheckFile(string filePath)
        {
            ///UIスレッド以外から画面へ更新する例
            for (int i = 0; i < 100; i++)
            {
                if (Cancelled)
                {
                    ///キャンセル
                    OnProgressChanged(new ProgressChangedEventArgs(i, CANCELLED));
                    return new VirusCheckResult(VirusCheckStatus.SUCCESS, filePath, null, null);
                }
                Thread.Sleep(20);
                ///ダミーの進捗通知
                OnProgressChanged(new ProgressChangedEventArgs(i, RUNNING));
            }
            ///ダミーの結果を返す
            if (IsSuccess)
            {
                OnProgressChanged(new ProgressChangedEventArgs(100, SUCCESS));
                return new VirusCheckResult(
                    VirusCheckStatus.SUCCESS,
                    filePath,
                    null,
                    null);
            }
            else
            {
                OnProgressChanged(new ProgressChangedEventArgs(100, VIRUS_DETECTED));
                return new VirusCheckResult(
                    VirusCheckStatus.VIRUS_DETECTED,
                    filePath,
                    new ErrorInfo("ERROR_COMMON_0002", null, "ウィルスが存在します：" + Path.GetFileName(filePath), null),
                    "XXXXウィルス");
            }

        }

        public List<VirusCheckResult> CheckFiles(string dirPath)
        {
            throw new NotImplementedException();
        }

        public event EventHandler<ProgressChangedEventArgs> ProgressChanged;

        /// UIスレッドで動作させる処理についてUICallHandler属性を付与
        [UICallHandler]
        protected virtual void OnProgressChanged(ProgressChangedEventArgs e)
        {
            EventHandler<ProgressChangedEventArgs> handler = ProgressChanged;
            if (handler != null)
            {
                handler(this, e);
            }
        }
    }
}
