﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Windows.ViewModel.Validation;
using System.ComponentModel;
using Terasoluna.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;

using System.Text.RegularExpressions;

namespace Terasoluna.TourSample.Client.Common.ViewData
{
    /// <summary>
    /// ユーザ詳細情報の共通画面データクラス
    /// </summary>
    public class UserDetail : ValidatableNestedViewData
    {
        [DisplayName("メールアドレス")]
        [RequiredValidator(Tag = "メールアドレス", Ruleset = "CRS01")]
        [RegexValidatorEx(@"\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*",
            RegexOptions.IgnoreCase, Tag = "メールアドレス", Ruleset = "CRS01")]
        public virtual string Email { get; set; }

        [DisplayName("住所")]
        public virtual string Address { get; set; }

        [DisplayName("会社名")]
        public virtual string CompanyName { get; set; }
    }
}
