﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Windows.ViewModel.Validation;
using System.ComponentModel;
using Terasoluna.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Text.RegularExpressions;
using Terasoluna.TourSample.Client.Common.Code;
using Terasoluna.TourSample.Client.Common.Properties;

namespace Terasoluna.TourSample.Client.Common.ViewData
{
    /// <summary>
    /// ユーザの共通画面データクラス
    /// </summary>
    [HasSelfValidation]
    public class User : ValidatableNestedViewData
    {
        private string passwordCustomError;

        public void SetPasswordCustomeError(string error)
        {
            this.passwordCustomError = error;
        }

        public void ClearPasswordCustomeError()
        {
            this.passwordCustomError = null;
        }

        public User()
        {
            Role = RoleEnum.User.ToString();
        }

        [DisplayName("ID")]
        [RequiredValidator(Tag = "ユーザID", Ruleset = "CRS01")]
        [RequiredValidator(Tag = "ユーザID", Ruleset = "CRS02")]
        public virtual string Id { get; set; }

        [DisplayName("パスワード")]
        [RequiredValidator(Tag = "パスワード", Ruleset = "CRS01")]
        [RequiredValidator(Tag = "パスワード", Ruleset = "CRS02")]
        public virtual string Password { get; set; }

        [DisplayName("名前")]
        [RequiredValidator(Tag = "名前", Ruleset = "CRS02")]
        [ZenkakuStringValidator(Tag = "名前", Ruleset = "CRS02")]
        public virtual string Name { get; set; }

        [DisplayName("ユーザ権限")]
        public virtual string Role { get; set; }

        /// <summary>
        /// ユーザ詳細情報
        /// </summary>
        public virtual UserDetail UserDetail { get; set; }

        [SelfValidation(Ruleset = "CRS02")]
        public void CustomValidate01(ValidationResults results)
        {
            ///親側のクラスの相関チェックエラーによりすでにPasswordのエラーがある場合
            if (!string.IsNullOrEmpty(passwordCustomError))
            {
                results.AddResult(new ValidationResult(Resources.ERROR_COMMON_0004,
                this, "Password", null, EventSpecificValidator.DefaultInstance));
            }
        }

    }
}
