﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Windows.ViewModel.Validation;
using System.ComponentModel;
using System.Reflection;
using System.Collections;

namespace Terasoluna.TourSample.Client.Common.ViewData
{
    /// ソート可能なリストデータの実装例
    /// DataGridViewでソート操作可能
    public class SortableNestedViewDataList<T> : ValidatableNestedViewDataList<T> where T : Terasoluna.Windows.ViewModel.Validation.ValidatableNestedViewData
    {
        private ListSortDirection sortDirectionValue;
        private PropertyDescriptor sortPropertyValue;
        private bool isSortedCore = false;

        //ソートグリフ（▼）を表示させるためには実装が必要
        /// <summary>
        /// リストが並べ替えられたかどうか
        /// </summary>
        protected override bool IsSortedCore
        {
            get
            {
                return isSortedCore;
            }
        }

        /// <summary>
        /// リストの並べ替えに使用されるプロパティ記述子
        /// </summary>
        protected override PropertyDescriptor SortPropertyCore
        {
            get {
                return sortPropertyValue; 
            }
        }

        /// <summary>
        /// リストが並べ替えられる順序
        /// </summary>
        protected override ListSortDirection SortDirectionCore
        {
            get { 
                return sortDirectionValue; 
            }
        }

        /// <summary>
        /// リストの並べ替えをサポートしているか
        /// </summary>
        protected override bool SupportsSortingCore
        {
            get
            {
                return true;
            }
        }

        /// <summary>
        /// リストを並べ替えします
        /// </summary>
        /// <param name="prop"></param>
        /// <param name="direction"></param>
        protected override void ApplySortCore(PropertyDescriptor prop, ListSortDirection direction)
        {
            // 実装されている場合は、SortPropertyValue と SortDirectionValue を設定します。
            sortPropertyValue = prop;
            sortDirectionValue = direction;

            //対象プロパティでソート
            List<T> items = this.Items as List<T>;
            if (items != null)
            {
                items.Sort(new PropertyComparer<T>(prop, direction));                
                isSortedCore = true;
            }
            else
            {
                isSortedCore = false;
            }
            OnListChanged(new ListChangedEventArgs(ListChangedType.Reset, -1));
        }

        /// <summary>
        /// リストの並べ替えを解除します
        /// </summary>
        protected override void RemoveSortCore()
        {
            //並べ替えを取り消すときは、最低でも並べ替え状態を false に設定する
            isSortedCore = false;
            //TODO:実際に並べ替えを取り消す処理
        }
    }

    /// <summary>
    /// リストの並べ替えのためのIComparer
    /// </summary>
    /// <typeparam name="T"></typeparam>
    class PropertyComparer<T> : IComparer<T>
    {
        private PropertyDescriptor prop;        
        private ListSortDirection direction;
        public PropertyComparer(PropertyDescriptor prop, ListSortDirection direction)
        {
            this.prop = prop;
            this.direction = direction;
        }

        #region IComparer メンバ

        public int Compare(T x, T y)
        {
            object xPropValue = prop.GetValue(x);
            object yPropValue = prop.GetValue(y);
            if (direction == ListSortDirection.Ascending)
            {
                return Comparer.Default.Compare(xPropValue, yPropValue);
            }
            else
            {
                return Comparer.Default.Compare(yPropValue, xPropValue);
            }
        }

        #endregion
    }


}
