﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Reflection;
using Terasoluna.TourSample.Client.Common.Code;
using System.Drawing.Design;
using Terasoluna.TourSample.Client.Common.ViewData;

namespace Terasoluna.TourSample.Client.Common.View
{
    /// <summary>
    /// ホテルランクのチェックボックスを表示する画面部品
    /// </summary>
    public partial class CMD_C03UserControl : UserControl
    {
        public CMD_C03UserControl()
        {
            InitializeComponent();
        }

        ///バインド対象のプロパティ
        [Bindable(true)]
        public virtual HotelRank HotelRank
        {
            get
            {
                return hotelRankBindingSource.DataSource as HotelRank;
            }

            set
            {
                if (hotelRankBindingSource.DataSource == value)
                {
                    return;
                }
                if (value == null)
                {
                    hotelRankBindingSource.DataSource = typeof(HotelRank);
                }
                else
                {
                    hotelRankBindingSource.DataSource = value;
                }               
                //値が変更されたらイベントを発生させる
                OnHotelRankChanged(EventArgs.Empty);
            }
        }
        
        /// PropertyNameChangedパターン
        public event EventHandler HotelRankChanged;

        /// <summary>
        /// HotelRankChangedイベントの発火
        /// </summary>   
        protected virtual void OnHotelRankChanged(EventArgs e)
        {
            EventHandler handler = HotelRankChanged;
            if (handler != null)
            {
                handler(this, e);
            }
        }

    }
}
