﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.TourSample.Client.Common.ViewData;

namespace Terasoluna.TourSample.Client.Common.View
{
    /// <summary>
    /// ツアー情報を入力する画面部品
    /// </summary>
    public partial class CMD_C01UserControl : UserControl
    {
        public CMD_C01UserControl()
        {
            InitializeComponent();
        }

        /// <summary>
        /// バインドする画面データのプロパティ
        /// Bindable属性を付与
        /// </summary>
        [Bindable(true)]
        public virtual Tour Tour
        {
            get
            {
                return tourBindingSource.DataSource as Tour;
            }
            set
            {
                if (tourBindingSource.DataSource == value)
                {
                    return;
                }
                if (value == null)
                {
                    tourBindingSource.DataSource = typeof(Tour);                    
                } else {
                    tourBindingSource.DataSource = value;
                }
                ///値が変更されたらイベントを発生させる
                OnTourChanged(EventArgs.Empty);
            }
        }

        /// <summary>
        /// 出発地の複数選択可能なリストボックスのErrorProviderのエラーをクリア
        /// </summary>
        public void ClearErrorProviderForDeptPlaceListBox()
        {
            errorProviderForDeptPlaceListBox.Clear();
        }

        /// <summary>
        /// 出発地のリストボックスのErrorProviderのエラーを表示
        /// </summary>
        /// <param name="message"></param>
        public void SetMessageToErrorProviderForDeptPlaceListBox(string message)
        {
            errorProviderForDeptPlaceListBox.SetError(deptPlaceListSelectedItemsBindableListBox, message);
        }

        /// <summary>
        /// PropertyNameChangedパターン
        /// </summary>
        public event EventHandler TourChanged;

         
        /// <summary>
        /// TourChangedパターンの発火
        /// </summary>
        protected virtual void OnTourChanged(EventArgs e)
        {
            EventHandler handler = TourChanged;
            if (handler != null)
            {
                handler(this, e);
            }
        }

    }
}
