﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.DataCopy;
using Terasoluna.Windows.Forms.MessageNotification;

using Terasoluna.TourSample.Client.Common.UserManageServiceReference;
using Terasoluna.TourSample.Client.Common.ViewData;
using Terasoluna.Windows.Forms.Controls;


namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ登録画面(3/3)パネル
    /// </summary>
    public partial class SC_B01_03_03Control : UserControl, ISC_B01_03_01MainContent, IContentControl
    {
        private SC_B01_03_03ViewData _viewData;

        public SC_B01_03_03ViewData ViewData
        {
            get
            {
                if (_viewData == null)
                {
                    _viewData = CreateViewData();
                }
                return _viewData;
            }
        }

        protected virtual SC_B01_03_03ViewData CreateViewData()
        {
            return ValidatableViewDataManager.CreateViewData<SC_B01_03_03ViewData>();
        }

        public SC_B01_03_03Control()
        {
            InitializeComponent();
        }

        #region ISC_B01_03_01MainContent メンバ

        object ISC_B01_03_01MainContent.ViewData
        {
            get { return this.ViewData; }
        }

        public User LoginUser
        {
            get { return this.ViewData.LoginUser; }
        }

        public string Title
        {
            get { return "ユーザ登録(3/3)"; }
        }

        public string ExecuteButtonCaption
        {
            get { return "登録"; }
        }

        public bool ExecutionEnabled
        {
            get { return true; }
        }

        public bool BackEnabled
        {
            get { return true; }
        }

        public bool HelpEnabled
        {
            get { return false; }
        }

        public string HelpUrl
        {
            get
            {
                throw new NotSupportedException();
            }
        }

        public void Execute()
        {
            b01_03_03_C01EventProcessWorker.RunWorkerAsync();
        }

        public void Back()
        {
            ContentPlaceHolder.ShowAndHideContent(typeof(SC_B01_03_02Control));
        }

        #endregion

        #region IContentControl メンバ

        [DefaultValue(null)]
        public ContentPlaceHolder ContentPlaceHolder { get; set; }

        public void HandleShowing(object sender, ControlEventArgs e)
        {
            ///ContentHolderが管理するパネルの画面データを取得し、現在のパネルの画面データへコピーする例
            SC_B01_03_01Control sc_B01_03_01Control = ContentPlaceHolder.GetContentControl<SC_B01_03_01Control>();
            SC_B01_03_02Control sc_B01_03_02Control = ContentPlaceHolder.GetContentControl<SC_B01_03_02Control>();
            DataCopyManager.Copy(sc_B01_03_01Control.ViewData, ViewData);
            MappingInfo mappingInfo = new MappingInfo();
            mappingInfo.AddMapping("UserDetail", "User.UserDetail");
            DataCopyManager.Copy(sc_B01_03_02Control.ViewData, ViewData, mappingInfo);

            //再描画ごとに表示を更新
            roleLabel1.Text =
                string.Equals(ViewData.User.Role, RoleEnum.User.ToString(), StringComparison.Ordinal)
                    ? "一般ユーザ" : "管理者";
        }

        public void HandleHidden(object sender, ControlEventArgs e)
        {
        }

        #endregion

        private void SC_B01_03_03Control_Load(object sender, EventArgs e)
        {
            sC_B01_03_03ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 登録ボタン押下時のイベント処理完了時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void b01_03_03_C01EventProcessWorker_Completed(object sender, EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                MessageNotifier.ShowInformationMessage(Terasoluna.TourSample.Client.Common.Properties.Resources.INFO_COMMON_0001);
                //業務処理成功時にContentHolder上のパネルを全てクローズし、別のパネルへ遷移
                ContentPlaceHolder.ShowWithCloseAllContents(typeof(SC_B01_03_00Control));
            }
            else if (e.Result.IsAnyBizLogicError || e.Result.IsAnyValidationError)
            {
                //業務エラー時には、入力開始時のパネルへ戻る例                
                ContentPlaceHolder.ShowAndHideContent(typeof(SC_B01_03_01Control));
            }
        }

        /// <summary>
        /// 要求データ作成直後
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void b01_03_03_C01EventProcessWorker_BuiltRequest(object sender, RequestDataBuiltEventArgs e)
        {
            ///階層ずれのデータのコピー処理
            SC_B01_03_03ViewData viewData = e.ViewData as SC_B01_03_03ViewData;
            UserDto dest = e.RequestData as UserDto;
            DataCopyManager.Copy(viewData.User, dest);
        }
    }
}
